/*
 * Decompiled with CFR 0.152.
 */
package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.helper.AjaxHelper;
import com.livquik.qwcore.helper.RequestValidator;
import com.livquik.qwcore.helper.ResponseProcessing;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.BaseRequest;
import com.livquik.qwcore.pojo.request.PartnerWallet.WalletConnectRequest;
import com.livquik.qwcore.pojo.request.payment.WalletPayRequest;
import com.livquik.qwcore.pojo.response.PartnerWallet.OtpResponse;
import com.livquik.qwcore.pojo.response.PartnerWallet.PartnerLoggingResponse;
import com.livquik.qwcore.pojo.response.PartnerWallet.RechargeModeResponse;
import com.livquik.qwcore.pojo.response.PartnerWallet.WalletBalanceResponse;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.payment.PaymentUsingWalletResponse;
import java.lang.reflect.Type;

public class PartnerWalletHelper {
    public static OtpResponse getOtpForWalletConnect(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type type = new TypeToken<GenericResponse<OtpResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("generateotp", "post", baseRequest, type, null);
        return (OtpResponse)new ResponseProcessing(OtpResponse.class).processResponse(genericResponse);
    }

    public static PartnerLoggingResponse connectPartnerWallet(WalletConnectRequest walletConnectRequest) throws QWException {
        RequestValidator.validate(walletConnectRequest);
        Type type = new TypeToken<GenericResponse<PartnerLoggingResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("connect", "post", walletConnectRequest, type, null);
        return (PartnerLoggingResponse)new ResponseProcessing(PartnerLoggingResponse.class).processResponse(genericResponse);
    }

    public static BaseResponse disconnectPartnerWallet(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type type = new TypeToken<GenericResponse>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("disconnect", "post", baseRequest, type, null);
        return new ResponseProcessing(BaseResponse.class).processResponse(genericResponse);
    }

    public static WalletBalanceResponse getWalletBalance(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type type = new TypeToken<GenericResponse<WalletBalanceResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("checkbalance", "post", baseRequest, type, null);
        return (WalletBalanceResponse)new ResponseProcessing(WalletBalanceResponse.class).processResponse(genericResponse);
    }

    public static PaymentUsingWalletResponse payThroughWallet(WalletPayRequest walletPayRequest) throws QWException {
        RequestValidator.validate(walletPayRequest);
        Type type = new TypeToken<GenericResponse<PaymentUsingWalletResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("pay", "post", walletPayRequest, type, null);
        return (PaymentUsingWalletResponse)new ResponseProcessing(PaymentUsingWalletResponse.class).processResponse(genericResponse);
    }

    public static RechargeModeResponse getRechargeMode(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type type = new TypeToken<GenericResponse<RechargeModeResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("rechargemodes", "post", baseRequest, type, null);
        return (RechargeModeResponse)new ResponseProcessing(RechargeModeResponse.class).processResponse(genericResponse);
    }
}

