package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.others.CreditRequest;
import com.livquik.qwcore.pojo.request.others.GCMRegIdBean;
import com.livquik.qwcore.pojo.request.others.OffersRequest;
import com.livquik.qwcore.pojo.request.others.PendingPaymentRequest;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.others.CreditResponse;
import com.livquik.qwcore.pojo.response.others.OffersResponse;
import com.livquik.qwcore.pojo.response.payment.PendingPaymentsResponse;

import java.lang.reflect.Type;

/**
 * Created by turing on 3/8/15.
 */
public class UserHelper {
    public CreditResponse getCreditInfo(CreditRequest getcreditRequest) throws QWException {
        RequestValidator.validate(getcreditRequest);
        Type finalType = new TypeToken<GenericResponse<CreditResponse>>() {
        }.getType();
        GenericResponse<CreditResponse> getCreditResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CREDIT, Constants.Ajax.REQUEST_POST, getcreditRequest, finalType, null);
        return (CreditResponse) new ResponseProcessing<CreditResponse>(CreditResponse.class).processResponse(getCreditResponse);
    }

    public OffersResponse getOffers(OffersRequest offerRequest) throws QWException {
        RequestValidator.validate(offerRequest);
        Type finalType = new TypeToken<GenericResponse<OffersResponse>>() {
        }.getType();
        GenericResponse<OffersResponse> getOffersResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_REFRESH_OFFERS, Constants.Ajax.REQUEST_POST, offerRequest, finalType, null);
        return (OffersResponse) new ResponseProcessing<OffersResponse>(OffersResponse.class).processResponse(getOffersResponse);
    }

    public BaseResponse registerGCMRegIDWithServer(GCMRegIdBean gcmRegIdBeanRequest) throws QWException {
        RequestValidator.validate(gcmRegIdBeanRequest);
        Type finalType = new TypeToken<GenericResponse>() {
        }.getType();
        GenericResponse getOffersResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_GCMREGID, Constants.Ajax.REQUEST_POST, gcmRegIdBeanRequest, finalType, null);
        return new ResponseProcessing<BaseResponse>(BaseResponse.class).processResponse(getOffersResponse);
    }

    //TODO this is to be done ..
    //public fun getOfferId - not needed in SDK as everything comes with /places route so NOT TO DO
    //public fun getNotification

    public PendingPaymentsResponse getPendingPayment(PendingPaymentRequest pendingPaymentRequest) throws QWException {
        RequestValidator.validate(pendingPaymentRequest);
        Type finalType = new TypeToken<GenericResponse<PendingPaymentsResponse>>() {
        }.getType();
        GenericResponse<PendingPaymentsResponse> pendingPaymentsResponseGenericResponse  = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PENDING_PAYMENTS, Constants.Ajax.REQUEST_POST, pendingPaymentRequest, finalType, null);
        return (PendingPaymentsResponse) new ResponseProcessing<PendingPaymentsResponse>(PendingPaymentsResponse.class).processResponse(pendingPaymentsResponseGenericResponse);
    }
}
