package com.livquik.qwcore.helper;

import android.util.Log;

import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;

/**
 * Created by turing on 3/8/15.
 */
public class ResponseProcessing<E> {
    private static final String TAG = ResponseProcessing.class.getName();

    Class responseClass = null;

    public ResponseProcessing(Class responseClass) {
        this.responseClass = responseClass;
    }

    public E createInstance() {
        try {
            return (E) this.responseClass.newInstance();
        } catch (InstantiationException e) {
            Log.e(TAG, "" + e);
        } catch (IllegalAccessException e) {
            Log.e(TAG, "" + e);
        }
        return null;
    }
    
    public BaseResponse processResponse(GenericResponse<E> response) throws QWException {
        System.out.println("In processing response function");
        if (response != null) {
            GenericResponse<BaseResponse> response_type = (GenericResponse<BaseResponse>) response;
            if (response_type.getData() != null) {
                response_type.getData().setMessage(response.getMessage());
                response_type.getData().setStatus(response.getStatus());
                return response_type.getData();
            } else {
                BaseResponse baseResponse = (BaseResponse) createInstance();
                if (baseResponse != null) {
                    baseResponse.setStatus(response.getStatus());
                    baseResponse.setMessage(response.getMessage());
                    return baseResponse;
                } else {
                    throw new QWException("Unable to process response. Please pass correct value while creating object of " + this.getClass().getName() + ".");
                }

            }
        } else {
            System.out.println("NULL SERVER RESPONSE");
            throw new QWException(Constants.Ajax.RESPONSE_NULL_RESPONSE);
        }
    }
}
