package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.request.register.VerifyOTPRequest;
import com.livquik.qwcore.pojo.response.register.RegisterUserResponse;
import com.livquik.qwcore.pojo.response.register.VerifyOTPResponse;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.register.MobileNumberVerificationRequest;
import com.livquik.qwcore.pojo.request.register.RegisterUserRequest;
import com.livquik.qwcore.pojo.request.register.UpdateProfileRequest;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.register.MobileNumberVerificationResponse;
import com.livquik.qwcore.pojo.response.register.UpdateProfileResponse;

import java.lang.reflect.Type;

/**
 * Created by turing on 3/8/15.
 */
public class RegistrationHelper {
    /**
     * @param verifyMobileNumberRequest Request Bean
     * @return MobileNumberVerificationResponse Bean containing response
     * @throws QWException In case of error/timeout
     */
    public MobileNumberVerificationResponse verifyMobileNumber(MobileNumberVerificationRequest verifyMobileNumberRequest) throws QWException {
        Type finalType = new TypeToken<GenericResponse<MobileNumberVerificationResponse>>() {
        }.getType();
        GenericResponse<MobileNumberVerificationResponse> mobileNumberVerificationResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PHONE_NUMBER, Constants.Ajax.REQUEST_POST, verifyMobileNumberRequest, finalType, null);
        return (MobileNumberVerificationResponse) new ResponseProcessing<MobileNumberVerificationResponse>(MobileNumberVerificationResponse.class).processResponse(mobileNumberVerificationResponse);
    }

    /**
     * @param verifyOTPRequest Request bean
     * @return VerifyOTPResponse Bean containing response
     * @throws QWException In case of error/timeout
     */
    public VerifyOTPResponse verifyOTP(VerifyOTPRequest verifyOTPRequest) throws QWException {
        Type finalType = new TypeToken<GenericResponse<VerifyOTPResponse>>() {
        }.getType();
        GenericResponse<VerifyOTPResponse> verifyOTPResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_VERIFY_OTP, Constants.Ajax.REQUEST_POST, verifyOTPRequest, finalType, null);
        return (VerifyOTPResponse) new ResponseProcessing<VerifyOTPResponse>(VerifyOTPResponse.class).processResponse(verifyOTPResponse);
    }

    /**
     * @param registerUserRequest Request bean
     * @return RegisterUserResponse Bean containing response
     * @throws QWException In case of error/timeout
     */
    public RegisterUserResponse registerUser(RegisterUserRequest registerUserRequest) throws QWException {
        Type finalType = new TypeToken<GenericResponse<RegisterUserResponse>>() {
        }.getType();
        GenericResponse<RegisterUserResponse> registerUserResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_REGISTER, Constants.Ajax.REQUEST_POST, registerUserRequest, finalType, null);
        return (RegisterUserResponse) new ResponseProcessing<RegisterUserResponse>(RegisterUserResponse.class).processResponse(registerUserResponse);
    }

    /**
     * @param updateProfileRequest Request bean
     * @return UpdateProfileResponse Bean cotaining response
     * @throws QWException In case of null response/timeout
     */
    public UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws QWException {
        Type finalType = new TypeToken<GenericResponse<UpdateProfileResponse>>() {
        }.getType();
        GenericResponse<UpdateProfileResponse> updateProfileResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_REGISTER, Constants.Ajax.REQUEST_POST, updateProfileRequest, finalType, updateProfileRequest.getUserid());
        return (UpdateProfileResponse) new ResponseProcessing<UpdateProfileResponse>(UpdateProfileResponse.class).processResponse(updateProfileResponse);
    }
}
