package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.others.GCMRegIdBean;
import com.livquik.qwcore.pojo.request.places.CheckinRequest;
import com.livquik.qwcore.pojo.request.places.PlacesRequest;
import com.livquik.qwcore.pojo.request.places.ReportRequest;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.places.CheckinResponse;
import com.livquik.qwcore.pojo.response.places.PlacesResponse;

import java.lang.reflect.Type;

/**
 * Created by dilip on 03/02/16.
 */
public class PlaceHelper {
    /**
     * @param allPlacesRequest
     * @return
     * @throws QWException
     */
    public static PlacesResponse getPlaces(PlacesRequest allPlacesRequest) throws QWException {
        RequestValidator.validate(allPlacesRequest);
        Type finalType = new TypeToken<GenericResponse<PlacesResponse>>() {
        }.getType();
        GenericResponse<PlacesResponse> allPlacesResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PLACES, Constants.Ajax.REQUEST_POST, allPlacesRequest, finalType, null);
        return (PlacesResponse) new ResponseProcessing<PlacesResponse>(PlacesResponse.class).processResponse(allPlacesResponse);
    }

    public static CheckinResponse checkin(CheckinRequest checkinRequest) throws QWException {
        RequestValidator.validate(checkinRequest);
        Type finalType = new TypeToken<GenericResponse<CheckinResponse>>() {
        }.getType();
        GenericResponse<CheckinResponse> checkinResponseGenericResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CHECKIN, Constants.Ajax.REQUEST_POST, checkinRequest, finalType, null);
        return (CheckinResponse) new ResponseProcessing<CheckinResponse>(CheckinResponse.class).processResponse(checkinResponseGenericResponse);
    }

    public static CheckinResponse checkout(CheckinRequest checkinRequest) throws QWException {
        RequestValidator.validate(checkinRequest);
        Type finalType = new TypeToken<GenericResponse<CheckinResponse>>() {
        }.getType();
        GenericResponse<CheckinResponse> checkinResponseGenericResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CHECKOUT, Constants.Ajax.REQUEST_POST, checkinRequest, finalType, null);
        return (CheckinResponse) new ResponseProcessing<CheckinResponse>(CheckinResponse.class).processResponse(checkinResponseGenericResponse);
    }


    public BaseResponse reportIssue(ReportRequest reportRequest) throws QWException {
        RequestValidator.validate(reportRequest);
        Type finalType = new TypeToken<GenericResponse>() {
        }.getType();
        GenericResponse getOffersResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_REPORT_ISSUE, Constants.Ajax.REQUEST_POST, reportRequest, finalType, null);
        return new ResponseProcessing<BaseResponse>(BaseResponse.class).processResponse(getOffersResponse);
    }


}
