package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.transaction.TransactionDetailsRequest;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.transaction.TransactionDetailsResponse;
import com.livquik.qwcore.pojo.response.transaction.TransactionHistoryResponse;
import com.livquik.qwcore.pojo.request.transaction.TransactionHistoryRequest;

import java.lang.reflect.Type;

/**
 * Created by turing on 3/8/15.
 */
public class TransactionHelper {

    public TransactionDetailsResponse getTransactionDetails(TransactionDetailsRequest transactionDetailsRequest) throws QWException {
        RequestValidator.validate(transactionDetailsRequest);
        Type finalType = new TypeToken<GenericResponse<TransactionDetailsResponse>>() {
        }.getType();
        GenericResponse<TransactionDetailsResponse> getTransactionDetailsResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_TRANSACTION_DETAILS, Constants.Ajax.REQUEST_POST, transactionDetailsRequest, finalType, null);
        return (TransactionDetailsResponse) new ResponseProcessing<TransactionDetailsResponse>(TransactionDetailsResponse.class).processResponse(getTransactionDetailsResponse);
    }

    public TransactionHistoryResponse getTransactionHistory(TransactionHistoryRequest transactionHistoryRequest) throws QWException {
        RequestValidator.validate(transactionHistoryRequest);
        Type finalType = new TypeToken<GenericResponse<TransactionHistoryResponse>>() {
        }.getType();
        GenericResponse<TransactionHistoryResponse> transactionHistoryResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_TRANSACTION_HISTORY, Constants.Ajax.REQUEST_POST, transactionHistoryRequest, finalType, null);
        return (TransactionHistoryResponse) new ResponseProcessing<TransactionHistoryResponse>(TransactionHistoryResponse.class).processResponse(transactionHistoryResponse);
    }
}
