package com.livquik.qwcore.helper;

import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.BaseRequest;

/**
 * Created by turing on 12/8/15.
 */
public class RequestValidator {
    public static void validate(BaseRequest request) throws QWException {
        if (request.getUserid() == null) {
            if (request.getPassphrase() != null) {
                throw new QWException(Constants.ERROR.MISSING_USERID_PASSWORD);
            }
            if (request.getMobile() == null || request.getSignature() == null || request.getPartnerid() == null) {
                throw new QWException(Constants.ERROR.MISSING_PATNER_CREDS);
            }
        } else if ((request.getUserid() != null && request.getPartnerid() != null) || (request.getPassphrase() != null && request.getSignature() != null)) {
                throw new QWException(Constants.ERROR.BOTH_USER_PARTNER_DETAILS_PASSED);
        } else {
            if (request.getPassphrase() == null) {
                throw new QWException(Constants.ERROR.MISSING_USERID_PASSWORD);
            }
        }
    }
}
