package com.livquik.qwcore.helper;


import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.payment.*;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.payment.*;

import java.lang.reflect.Type;

/**
 * Created by turing on 3/8/15.
 */
public class PaymentHelper {
    /**
     * @param rejectPaymentRequest
     * @return
     * @throws QWException
     */
    public static RejectPaymentResponse rejectPayment(RejectPaymentRequest rejectPaymentRequest) throws QWException {
        RequestValidator.validate(rejectPaymentRequest);
        Type finalType = new TypeToken<GenericResponse<RejectPaymentResponse>>() {
        }.getType();
        GenericResponse<RejectPaymentResponse> rejectPaymentResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_REJECT_PAYMENT, Constants.Ajax.REQUEST_POST, rejectPaymentRequest, finalType, null);
        return (RejectPaymentResponse) new ResponseProcessing<RejectPaymentResponse>(RejectPaymentResponse.class).processResponse(rejectPaymentResponse);
    }

    /**
     * @param cancelPaymentRequest
     * @return
     * @throws QWException
     */
    public static CancelPaymentResponse cancelPayment(CancelPaymentRequest cancelPaymentRequest) throws QWException {
        RequestValidator.validate(cancelPaymentRequest);
        Type finalType = new TypeToken<GenericResponse<CancelPaymentResponse>>() {
        }.getType();
        GenericResponse<CancelPaymentResponse> cancelPaymentResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CANCEL_PAYMENT, Constants.Ajax.REQUEST_POST, cancelPaymentRequest, finalType, null);
        return (CancelPaymentResponse) new ResponseProcessing<CancelPaymentResponse>(CancelPaymentResponse.class).processResponse(cancelPaymentResponse);
    }

    /**
     * @param dropPaymentRequest
     * @return
     * @throws QWException
     */
    public static DropPaymentResponse dropPayment(DropPaymentRequest dropPaymentRequest) throws QWException {
        RequestValidator.validate(dropPaymentRequest);
        Type finalType = new TypeToken<GenericResponse<DropPaymentResponse>>() {
        }.getType();
        GenericResponse<DropPaymentResponse> dropPaymentResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_DROP_PAYMENT, Constants.Ajax.REQUEST_POST, dropPaymentRequest, finalType, null);
        return (DropPaymentResponse) new ResponseProcessing<DropPaymentResponse>(DropPaymentResponse.class).processResponse(dropPaymentResponse);
    }

    /**
     * @param paymentUsingNetBankingRequest
     * @return
     * @throws QWException
     */
    public static PaymentUsingNetBankingResponse paymentUsingNetBanking(PaymentUsingNetBankingRequest paymentUsingNetBankingRequest) throws QWException {
        RequestValidator.validate(paymentUsingNetBankingRequest);
        Type finalType = new TypeToken<GenericResponse<PaymentUsingNetBankingResponse>>() {
        }.getType();
        GenericResponse<PaymentUsingNetBankingResponse> paymentUsingNetBankingResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PAY, Constants.Ajax.REQUEST_POST, paymentUsingNetBankingRequest, finalType, null);
        return (PaymentUsingNetBankingResponse) new ResponseProcessing<PaymentUsingNetBankingResponse>(PaymentUsingNetBankingResponse.class).processResponse(paymentUsingNetBankingResponse);
    }

    /**
     * @param paymentUsingSavedPaymentCardRequest
     * @return
     * @throws QWException
     */
    public static PaymentUsingSavedPaymentCardResponse paymentUsingSavedPaymentCard(PaymentUsingSavedPaymentCardRequest paymentUsingSavedPaymentCardRequest) throws QWException {
        RequestValidator.validate(paymentUsingSavedPaymentCardRequest);
        Type finalType = new TypeToken<GenericResponse<PaymentUsingSavedPaymentCardResponse>>() {
        }.getType();
        GenericResponse<PaymentUsingSavedPaymentCardResponse> paymentUsingSavedPaymentCardRespone = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PAY, Constants.Ajax.REQUEST_POST, paymentUsingSavedPaymentCardRequest, finalType, null);
        return (PaymentUsingSavedPaymentCardResponse) new ResponseProcessing<PaymentUsingSavedPaymentCardResponse>(PaymentUsingSavedPaymentCardResponse.class).processResponse(paymentUsingSavedPaymentCardRespone);
    }

    /**
     * @param paymentUsingNewPaymentCardRequest
     * @return
     * @throws QWException
     */
    public static PaymentUsingNewPaymentCardResponse paymentUsingNewPaymentCard(PaymentUsingNewPaymentCardRequest paymentUsingNewPaymentCardRequest) throws QWException {
        RequestValidator.validate(paymentUsingNewPaymentCardRequest);
        Type finalType = new TypeToken<GenericResponse<PaymentUsingNewPaymentCardResponse>>() {
        }.getType();
        GenericResponse<PaymentUsingNewPaymentCardResponse> paymentUsingNewPaymentCardResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PAY, Constants.Ajax.REQUEST_POST, paymentUsingNewPaymentCardRequest, finalType, null);
        return (PaymentUsingNewPaymentCardResponse) new ResponseProcessing<PaymentUsingNewPaymentCardResponse>(PaymentUsingNewPaymentCardResponse.class).processResponse(paymentUsingNewPaymentCardResponse);
    }

    public static PaymentFullFilledResponse paymentFullFilled(PaymentFullFilledRequest paymentFullFilledRequest) throws QWException {
        RequestValidator.validate(paymentFullFilledRequest);
        Type finalType = new TypeToken<GenericResponse<PaymentFullFilledResponse>>() {
        }.getType();
        GenericResponse<PaymentFullFilledResponse> paymentFullFilledResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PAY, Constants.Ajax.REQUEST_POST, paymentFullFilledRequest, finalType, null);
        return (PaymentFullFilledResponse) new ResponseProcessing<PaymentFullFilledResponse>(PaymentFullFilledResponse.class).processResponse(paymentFullFilledResponse);
    }

    public static RechargePrepaidCardUsingNewPaymentCardResponse rechargePrepaidCardUsindNewPaymentCard(RechargePrepaidCardUsingNewPaymentCardRequest rechargePrepaidCardUsindNewPaymentCardRequest) throws QWException {
        RequestValidator.validate(rechargePrepaidCardUsindNewPaymentCardRequest);
        Type finalType = new TypeToken<GenericResponse<RechargePrepaidCardUsingNewPaymentCardResponse>>() {
        }.getType();
        GenericResponse<RechargePrepaidCardUsingNewPaymentCardResponse> rechargePrepaidCardUsindNewPaymentCard = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_RECHARGE, Constants.Ajax.REQUEST_POST, rechargePrepaidCardUsindNewPaymentCardRequest, finalType, null);
        return (RechargePrepaidCardUsingNewPaymentCardResponse) new ResponseProcessing<RechargePrepaidCardUsingNewPaymentCardResponse>(RechargePrepaidCardUsingNewPaymentCardResponse.class).processResponse(rechargePrepaidCardUsindNewPaymentCard);
    }

    public static RechargePrepaidCardUsingSavedPaymentCardResponse rechargePrepaidCardUsingSavedPaymentCard(RechargePrepaidCardUsingSavedPaymentCardRequest rechargePrepaidCardUsingSavedPaymentCardRequest) throws QWException {
        RequestValidator.validate(rechargePrepaidCardUsingSavedPaymentCardRequest);
        Type finalType = new TypeToken<GenericResponse<RechargePrepaidCardUsingSavedPaymentCardResponse>>() {
        }.getType();
        GenericResponse<RechargePrepaidCardUsingSavedPaymentCardResponse> rechargePrepaidCardUsindSavedPaymentCardResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_RECHARGE, Constants.Ajax.REQUEST_POST, rechargePrepaidCardUsingSavedPaymentCardRequest, finalType, null);
        return (RechargePrepaidCardUsingSavedPaymentCardResponse) new ResponseProcessing<RechargePrepaidCardUsingSavedPaymentCardResponse>(RechargePrepaidCardUsingSavedPaymentCardResponse.class).processResponse(rechargePrepaidCardUsindSavedPaymentCardResponse);
    }

    public static RechargePrepaidCardUsingNetBankingResponse rechargePrepaidCardUsingNetBanking(RechargePrepaidCardUsingNetBankingRequest rechargePrepaidCardUsingNetBankingRequest) throws QWException {
        RequestValidator.validate(rechargePrepaidCardUsingNetBankingRequest);
        Type finalType = new TypeToken<GenericResponse<RechargePrepaidCardUsingNetBankingResponse>>() {
        }.getType();
        GenericResponse<RechargePrepaidCardUsingNetBankingResponse> response = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_RECHARGE, Constants.Ajax.REQUEST_POST, rechargePrepaidCardUsingNetBankingRequest, finalType, null);
        return (RechargePrepaidCardUsingNetBankingResponse) new ResponseProcessing<RechargePrepaidCardUsingNetBankingResponse>(RechargePrepaidCardUsingNetBankingResponse.class).processResponse(response);
    }

    public static FindModesOfPaymentResponse findModesOfPayment(FindModesOfPaymentRequest findModesOfPaymentRequest) throws QWException {
        RequestValidator.validate(findModesOfPaymentRequest);
        Type finalType = new TypeToken<GenericResponse<FindModesOfPaymentResponse>>() {
        }.getType();
        GenericResponse<FindModesOfPaymentResponse> findModesOfPaymentResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PAYMENT_MODE, Constants.Ajax.REQUEST_POST, findModesOfPaymentRequest, finalType, null);
        return (FindModesOfPaymentResponse) new ResponseProcessing<FindModesOfPaymentResponse>(FindModesOfPaymentResponse.class).processResponse(findModesOfPaymentResponse);
    }

    public static HowYouPaidResponse getHowYouPaid(HowYouPaidRequest howYouPaidRequest) throws QWException {
        RequestValidator.validate(howYouPaidRequest);
        Type finalType = new TypeToken<GenericResponse<HowYouPaidResponse>>() {
        }.getType();
        GenericResponse<HowYouPaidResponse> howYouPaidResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_TRANSACTION_MODE, Constants.Ajax.REQUEST_POST, howYouPaidRequest, finalType, null);
        return (HowYouPaidResponse) new ResponseProcessing<HowYouPaidResponse>(HowYouPaidResponse.class).processResponse(howYouPaidResponse);
    }

    public static BillResponse requestBill(BillRequest request) throws QWException{
        RequestValidator.validate(request);
        Type finalType = new TypeToken<GenericResponse<BillResponse>>() {
        }.getType();
        GenericResponse<BillResponse> response = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_REQUEST_BILL, Constants.Ajax.REQUEST_POST, request, finalType, null);
        return (BillResponse) new ResponseProcessing<BillResponse>(BillResponse.class).processResponse(response);
    }
}
