package com.livquik.qwcore.helper;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

/**
 * Created by turing on 9/9/15.
 */
public class ConnectivityHelper {

    public static boolean checkConnectivity(Context context) {
        if (context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager) context
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mobileDataeNetInfo = connectivityManager
                    .getNetworkInfo(ConnectivityManager.TYPE_MOBILE);
            NetworkInfo wifiNetInfo = connectivityManager
                    .getNetworkInfo(ConnectivityManager.TYPE_WIFI);
            boolean isMobileDataConnected = mobileDataeNetInfo != null
                    && mobileDataeNetInfo.isConnectedOrConnecting();

            boolean isWifiConnected = wifiNetInfo != null
                    && wifiNetInfo.isConnectedOrConnecting();

            return isMobileDataConnected || isWifiConnected;
        } else {
            return true; //assuming network is available
        }
    }
}
