package com.livquik.qwcore;

/**
 * Created by turing on 2/8/15.
 */
public class Constants {


    // Various configs
    public static final class Configs

    {
        public static final String STAGING = "staging";
        public static final String TEST = "test";
        public static final String LIVE = "live";
        public static final String DEV = "dev";
        public static final String UAT = "uat";
        public static final String HTTP = "http";
        public static final String HTTPS = "https";
    }

    public static final class Ajax {
        public static final String SERVER_URL_LIVE = "server.livquik.com";
        public static final String SERVER_URL_STAGING = "staging.quikpay.in";
        public static final String SERVER_URL_TEST = "test.quikwallet.com";
        public static final String SERVER_URL_UAT = "uat.quikpay.in";
        public static final String SERVER_URL_DEV = "192.168.1.100";
        //public static final static final String SERVER_URL_DEV = "livquik.hopto.org";

        public static final String SERVER_PORT_DEV = "3014";    // Change this only (DO NOT commit).
        public static final String ENDPOINT_PREFIX = "api/public";
        public static final String ENDPOINT_PHONE_NUMBER = "verify";
        public static final String ENDPOINT_VERIFY_OTP = "verifyotp";
        public static final String ENDPOINT_REGISTER = "profiles";
        public static final String ENDPOINT_CHANGE_PASSWORD = "changepassword";
        public static final String ENDPOINT_LOGIN = "initialize";
        public static final String ENDPOINT_ADD_CARD = "addcard";
        public static final String ENDPOINT_DELETE_CARD = "deletecard";
        public static final String ENDPOINT_CHANGE_DEFAULT_CARD = "changedefaultcard";
        public static final String ENDPOINT_TRANSACTION_HISTORY = "transactionhistory";
        public static final String ENDPOINT_TRANSACTION_DETAILS = "transactiondetails";
        public static final String ENDPOINT_RECHARGE = "recharge";
        public static final String ENDPOINT_REJECT_PAYMENT = "rejectpayment";
        public static final String ENDPOINT_REQUEST_BILL = "requestbill";
        public static final String REQUEST_GET = "get";
        public static final String REQUEST_POST = "post";
        public static final String RESPONSE_NULL_RESPONSE = "NULL SERVER RESPONSE";
        public static final String RESPONSE_NETWORK_TIMEOUT = "Network Failure/Timeout or null returned by the server";
        public static final String RESPONSE_STATUS_SUCCESS = "success";
        public static final String RESPONSE_JSON_EXCEPTION = "Unable to create response object";
        public static final String ENDPOINT_CREDIT = "credit";
        public static final String ENDPOINT_PAYMENT_MODE = "howtopay";
        public static final String ENDPOINT_TRANSACTION_MODE = "howyoupaid";
        public static final String ENDPOINT_PAY = "pay";
        public static final String ENDPOINT_CARDS = "cards";
        public static final String ENDPOINT_REFRESH_OFFERS = "offers";
        public static final String ENDPOINT_CANCEL_PAYMENT = "cancelpayment";
        public static final String ENDPOINT_DROP_PAYMENT = "droppayment";
        public static final String NETWORK_REQUEST_START = "making_network_request";
        public static final String NETWORK_REQUEST_END = "network_request_completed";
        public static final String ENDPOINT_3_D_SECURE = "2fr/req";
        public static final String ENDPOINT_PLACES = "outlets";
        public static final String ENDPOINT_CHECKIN = "checkin";
        public static final String ENDPOINT_CHECKOUT = "checkout";
        public static final String ENDPOINT_GCMREGID = "updatepush";
        public static final String ENDPOINT_PENDING_PAYMENTS = "pendingpayments";
        public static final String ENDPOINT_REPORT_ISSUE = "reportissue";

    }


    public static final class PAYMENT_TYPES {
        public static final String NETBANKING = "netbanking";
        public static final String PAYMENTCARD = "paymentcard";
        public static final String RECHARGE = "recharge";
    }

    public static final class CARD_TYPE {
        public static final String PAYMENT = "payment";
        public static final String PREPAID = "prepaid";
    }

    public static final class ERROR {
        public static final String MISSING_USERID_PASSWORD = "Please provide userid and passphrase";
        public static final String MISSING_PATNER_CREDS = "Please provide mobile number, signature and patnerid";
        public static final String IOEXCEPTION_IN_AJAX_CALL = "IOException: The request could not be executed due to cancellation, a connectivity problem or timeout";
        public static final String UNABLE_TO_CALL_SERVER = "OOPS!! Unable to call server";
        public static final String NULL_RESPONSE = "NULL RESPONSE";
        public static final String ERROR_WHILE_CREATING_RESPONSE_OBJECT = "Error while creating response object ";
        public static final String BOTH_USER_PARTNER_DETAILS_PASSED = "Please pass either user or partner details";
        public static final String NETWORK_UNREACHABLE_MSG = "Your device seems to have problem connecting to the network. Please check your internet connection.";
    }
}

