/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CommitResult;
import com.linecorp.centraldogma.server.command.ContentTransformer;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.metadata.HolderWithRevision;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.AbstractCacheableCall;
import com.linecorp.centraldogma.server.storage.repository.HasWeight;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class RepositorySupport<T> {
    private final ProjectManager projectManager;
    private final CommandExecutor executor;
    private final Class<T> entryClass;

    RepositorySupport(ProjectManager projectManager, CommandExecutor executor, Class<T> entryClass) {
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.entryClass = Objects.requireNonNull(entryClass, "entryClass");
    }

    public ProjectManager projectManager() {
        return this.projectManager;
    }

    CompletableFuture<HolderWithRevision<T>> fetch(String projectName, String repoName, String path) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        return this.fetch((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName), path);
    }

    private CompletableFuture<HolderWithRevision<T>> fetch(Repository repository, String path) {
        Objects.requireNonNull(path, "path");
        Revision revision = RepositorySupport.normalize(repository);
        return this.fetch(repository, path, revision);
    }

    private CompletableFuture<HolderWithRevision<T>> fetch(Repository repository, String path, Revision revision) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(revision, "revision");
        CacheableFetchCall<T> cacheableFetchCall = new CacheableFetchCall<T>(repository, revision, path, this.entryClass);
        return repository.execute(cacheableFetchCall);
    }

    CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, Change<?> change) {
        return this.push(projectName, repoName, author, commitSummary, change, Revision.HEAD);
    }

    private CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, Change<?> change, Revision revision) {
        Objects.requireNonNull(change, "change");
        return this.push(projectName, repoName, author, commitSummary, (Iterable<Change<?>>)ImmutableList.of(change), revision);
    }

    private CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, Iterable<Change<?>> changes, Revision revision) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(commitSummary, "commitSummary");
        Objects.requireNonNull(changes, "changes");
        return this.executor.execute(Command.push(author, projectName, repoName, revision, commitSummary, "", Markup.PLAINTEXT, changes)).thenApply(CommitResult::revision);
    }

    CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, ContentTransformer<JsonNode> transformer) {
        return this.push(projectName, repoName, author, commitSummary, transformer, false);
    }

    CompletableFuture<Revision> push(String projectName, String repoName, Author author, String commitSummary, ContentTransformer<JsonNode> transformer, boolean forcePush) {
        Objects.requireNonNull(projectName, "projectName");
        Objects.requireNonNull(repoName, "repoName");
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(commitSummary, "commitSummary");
        Objects.requireNonNull(transformer, "transformer");
        Command<CommitResult> command = Command.transform(null, author, projectName, repoName, Revision.HEAD, commitSummary, "", Markup.PLAINTEXT, transformer);
        if (forcePush) {
            command = Command.forcePush(command);
        }
        return ((CompletableFuture)this.executor.execute(command).thenApply(CommitResult::revision)).exceptionally(cause -> {
            Throwable peeled = Exceptions.peel((Throwable)cause);
            if (peeled instanceof RedundantChangeException) {
                Revision revision = ((RedundantChangeException)peeled).headRevision();
                assert (revision != null);
                return revision;
            }
            return (Revision)Exceptions.throwUnsafely((Throwable)peeled);
        });
    }

    static Revision normalize(Repository repository) {
        Objects.requireNonNull(repository, "repository");
        try {
            return repository.normalizeNow(Revision.HEAD);
        }
        catch (Throwable cause) {
            return (Revision)Exceptions.throwUnsafely((Throwable)cause);
        }
    }

    private static class CacheableFetchCall<U>
    extends AbstractCacheableCall<HolderWithRevision<U>> {
        private final Revision revision;
        private final String path;
        private final Class<U> entryClass;
        private final int hashCode;

        CacheableFetchCall(Repository repo, Revision revision, String path, Class<U> entryClass) {
            super(repo);
            this.revision = revision;
            this.path = path;
            this.entryClass = entryClass;
            this.hashCode = Objects.hash(revision, path, entryClass) * 31 + System.identityHashCode(repo);
            assert (!revision.isRelative());
        }

        @Override
        public int weigh(HolderWithRevision<U> value) {
            int weight = this.path.length();
            U object = value.object();
            if (object instanceof HasWeight) {
                weight += ((HasWeight)object).weight();
            }
            return weight;
        }

        @Override
        public CompletableFuture<HolderWithRevision<U>> execute() {
            RepositoryCache.logger.debug("Cache miss: {}", (Object)this);
            return ((CompletableFuture)this.repo().get(this.revision, this.path).thenApply(this::convertWithJackson)).thenApply(obj -> HolderWithRevision.of(obj, this.revision));
        }

        U convertWithJackson(Entry<?> entry) {
            Objects.requireNonNull(entry, "entry");
            try {
                return (U)Jackson.treeToValue((TreeNode)((TreeNode)entry.content()), this.entryClass);
            }
            catch (Throwable cause) {
                return (U)Exceptions.throwUnsafely((Throwable)cause);
            }
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            CacheableFetchCall that = (CacheableFetchCall)o;
            return this.revision.equals((Object)that.revision) && this.path.equals(that.path) && this.entryClass == that.entryClass;
        }

        @Override
        protected void toString(MoreObjects.ToStringHelper helper) {
            helper.add("revision", (Object)this.revision).add("path", (Object)this.path).add("entryClass", this.entryClass);
        }
    }
}

