/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitIdDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.EncryptionGitStorage;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public final class RocksDbCommitIdDatabase
implements CommitIdDatabase {
    private final EncryptionGitStorage storage;
    @Nullable
    private volatile Revision headRevision;

    public RocksDbCommitIdDatabase(EncryptionGitStorage storage, @Nullable Revision headRevision) {
        this.storage = Objects.requireNonNull(storage, "storage");
        this.headRevision = headRevision;
    }

    @Override
    @Nullable
    public Revision headRevision() {
        return this.headRevision;
    }

    @Override
    public ObjectId get(Revision revision) {
        Revision headRevision = this.headRevision;
        Preconditions.checkState((headRevision != null ? 1 : 0) != 0, (String)"initial commit not available yet: %s/%s", (Object)this.storage.projectName(), (Object)this.storage.repoName());
        Preconditions.checkArgument((!revision.isRelative() ? 1 : 0) != 0, (String)"revision: %s (expected: an absolute revision)", (Object)revision);
        if (revision.major() > headRevision.major()) {
            throw new RevisionNotFoundException(revision);
        }
        return this.storage.getRevisionObjectId(revision);
    }

    @Override
    public void put(Revision revision, ObjectId commitId) {
        Revision headRevision = this.headRevision;
        Revision expected = headRevision == null ? Revision.INIT : headRevision.forward(1);
        Preconditions.checkState((boolean)revision.equals((Object)expected), (String)"incorrect revision: %s (expected: %s)", (Object)revision, (Object)expected);
        this.storage.putRevisionObjectId(revision, commitId);
        if (headRevision == null || headRevision.major() < revision.major()) {
            this.headRevision = revision;
        }
    }

    @Override
    public void rebuild(Repository gitRepo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }
}

