/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.primitives.Ints;
import com.linecorp.centraldogma.server.internal.storage.AesGcmSivCipher;
import com.linecorp.centraldogma.server.internal.storage.encryption.EncryptionUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.rocksdb.GitObjectMetadata;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageException;
import com.linecorp.centraldogma.server.storage.encryption.EncryptionStorageManager;
import com.linecorp.centraldogma.server.storage.encryption.SecretKeyWithVersion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.SymbolicRef;

public final class EncryptionGitStorage {
    public static final String OBJS = "objs/";
    public static final String REFS = "refs/";
    public static final String REV2SHA = "rev2sha/";
    private final String projectName;
    private final String repoName;
    private final byte[] objectKeyPrefix;
    private final byte[] refsKeyPrefix;
    private final byte[] rev2ShaPrefix;
    private final EncryptionStorageManager encryptionStorageManager;
    private final SecretKeyWithVersion currentDek;
    private final ConcurrentHashMap<Integer, SecretKey> deks = new ConcurrentHashMap();

    public EncryptionGitStorage(String projectName, String repoName, EncryptionStorageManager encryptionStorageManager) {
        this.projectName = projectName;
        this.repoName = repoName;
        String projectRepoPrefix = projectName + '/' + repoName + '/';
        this.objectKeyPrefix = (projectRepoPrefix + OBJS).getBytes(StandardCharsets.UTF_8);
        this.refsKeyPrefix = projectRepoPrefix.getBytes(StandardCharsets.UTF_8);
        this.rev2ShaPrefix = (projectRepoPrefix + REV2SHA).getBytes(StandardCharsets.UTF_8);
        this.encryptionStorageManager = encryptionStorageManager;
        this.currentDek = encryptionStorageManager.getCurrentDek(projectName, repoName);
        this.deks.put(this.currentDek.version(), this.currentDek.secretKey());
    }

    String projectName() {
        return this.projectName;
    }

    String repoName() {
        return this.repoName;
    }

    private SecretKey dek(int version) {
        return this.deks.computeIfAbsent(version, key -> this.encryptionStorageManager.getDek(this.projectName, this.repoName, version));
    }

    ObjectId insertObject(ObjectId objectId, int type, byte[] data, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > data.length) {
            throw new IllegalArgumentException("Invalid offset or length: " + off + ", " + len);
        }
        byte[] metadataKey = this.objectMetadataKey(objectId);
        if (this.encryptionStorageManager.containsMetadata(metadataKey)) {
            return objectId;
        }
        SecretKeyWithVersion currentDek = this.currentDek;
        byte[] nonce = AesGcmSivCipher.generateNonce();
        byte[] objectDek = AesGcmSivCipher.generateAes256Key();
        byte[] objectWdek = this.encrypt(currentDek.secretKey(), nonce, objectDek, 0, 32);
        assert (objectWdek.length == 48);
        GitObjectMetadata gitObjectMetadata = GitObjectMetadata.of(currentDek.version(), nonce, type, objectWdek);
        SecretKeySpec keySpec = AesGcmSivCipher.aesSecretKey(objectDek);
        byte[] encryptedId = this.encryptObjectId(keySpec, nonce, objectId);
        byte[] encryptedValue = this.encrypt(keySpec, nonce, data, off, len);
        this.encryptionStorageManager.putObject(metadataKey, gitObjectMetadata.toBytes(), encryptedId, encryptedValue);
        return objectId;
    }

    @VisibleForTesting
    public byte[] objectMetadataKey(ObjectId objectId) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.objectKeyPrefix.length + 20);
        byteBuffer.put(this.objectKeyPrefix);
        objectId.copyRawTo(byteBuffer);
        return byteBuffer.array();
    }

    private byte[] encryptObjectId(SecretKey dek, byte[] nonce, ObjectId objectId) {
        byte[] idBytes = new byte[20];
        objectId.copyRawTo(idBytes, 0);
        return this.encrypt(dek, nonce, idBytes, 0, 20);
    }

    private byte[] encrypt(SecretKey dek, byte[] nonce, byte[] data, int offset, int length) {
        try {
            return AesGcmSivCipher.encrypt(dek, nonce, data, offset, length);
        }
        catch (Exception e) {
            throw new EncryptionStorageException("Failed to encrypt data in " + this.projectName + '/' + this.repoName, e);
        }
    }

    private byte[] decrypt(SecretKey key, byte[] nonce, byte[] ciphertext) {
        try {
            return AesGcmSivCipher.decrypt(key, nonce, ciphertext);
        }
        catch (Exception e) {
            throw new EncryptionStorageException("Failed to decrypt data in " + this.projectName + '/' + this.repoName, e);
        }
    }

    @Nullable
    public ObjectLoader getObject(ObjectId objectId, int typeHint) throws IncorrectObjectTypeException {
        SecretKeySpec objectDek;
        byte[] metadataKey = this.objectMetadataKey(objectId);
        byte[] metadata = this.encryptionStorageManager.getMetadata(metadataKey);
        if (metadata == null) {
            return null;
        }
        int actualType = EncryptionUtil.getInt(metadata, 16);
        if (typeHint != -1 && actualType != typeHint) {
            throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
        }
        int keyVersion = EncryptionUtil.getInt(metadata, 0);
        SecretKey dek = this.dek(keyVersion);
        GitObjectMetadata gitObjectMetadata = GitObjectMetadata.fromBytes(metadata);
        try {
            objectDek = gitObjectMetadata.objectDek(dek);
        }
        catch (Exception e) {
            throw new EncryptionStorageException("Failed to get object dek in " + this.projectName + '/' + this.repoName + " for " + objectId, e);
        }
        byte[] encryptedKey = this.encryptObjectId(objectDek, gitObjectMetadata.nonce(), objectId);
        byte[] value = this.encryptionStorageManager.getObject(encryptedKey, metadataKey);
        if (value == null) {
            return null;
        }
        byte[] decrypted = this.decrypt(objectDek, gitObjectMetadata.nonce(), value);
        return new DecryptedObjectLoader(decrypted, actualType);
    }

    @Nullable
    @VisibleForTesting
    public Ref readRef(String refName) {
        byte[] refNameBytes = refName.getBytes(StandardCharsets.UTF_8);
        byte[] metadataKey = this.refMetadataKey(refNameBytes);
        byte[] metadata = this.encryptionStorageManager.getMetadata(metadataKey);
        if (metadata == null) {
            return null;
        }
        byte[] nonce = new byte[12];
        System.arraycopy(metadata, 4, nonce, 0, 12);
        int keyVersion = EncryptionUtil.getInt(metadata, 0);
        SecretKey dek = this.dek(keyVersion);
        byte[] encryptedRefName = this.encrypt(dek, nonce, refNameBytes, 0, refNameBytes.length);
        byte[] encryptedRefValue = this.encryptionStorageManager.getObjectId(encryptedRefName, metadataKey);
        if (encryptedRefValue == null) {
            return null;
        }
        byte[] refValue = this.decrypt(dek, nonce, encryptedRefValue);
        if (!EncryptionGitStorage.isSymRef(refValue, refValue.length)) {
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.LOOSE, refName, ObjectId.fromRaw((byte[])refValue));
        }
        byte[] refValueWithoutSymRef = new byte[refValue.length - 5];
        System.arraycopy(refValue, 5, refValueWithoutSymRef, 0, refValueWithoutSymRef.length);
        String targetRefName = new String(refValueWithoutSymRef, StandardCharsets.UTF_8);
        Ref targetRef = this.readRef(targetRefName);
        if (targetRef != null) {
            return new SymbolicRef(refName, targetRef);
        }
        return new SymbolicRef(refName, (Ref)new ObjectIdRef.Unpeeled(Ref.Storage.NEW, targetRefName, null));
    }

    private static boolean isSymRef(byte[] buf, int n) {
        if (n < 6) {
            return false;
        }
        return buf[0] == 114 && buf[1] == 101 && buf[2] == 102 && buf[3] == 58 && buf[4] == 32;
    }

    RefUpdate.Result updateRef(String refName, ObjectId objectId, RefUpdate.Result desiredResult) {
        byte[] previousEncryptedRefName;
        byte[] refNameBytes = refName.getBytes(StandardCharsets.UTF_8);
        SecretKeyWithVersion currentDek = this.currentDek;
        byte[] metadataKey = this.refMetadataKey(refNameBytes);
        byte[] metadata = new byte[16];
        EncryptionUtil.putInt(metadata, 0, currentDek.version());
        byte[] nonce = AesGcmSivCipher.generateNonce();
        System.arraycopy(nonce, 0, metadata, 4, 12);
        byte[] encryptedRefName = this.encrypt(currentDek.secretKey(), nonce, refNameBytes, 0, refNameBytes.length);
        byte[] encryptedId = this.encryptObjectId(currentDek.secretKey(), nonce, objectId);
        byte[] previousMetadata = this.encryptionStorageManager.getMetadata(metadataKey);
        if (previousMetadata == null) {
            previousEncryptedRefName = null;
        } else {
            byte[] previousNonce = new byte[12];
            System.arraycopy(previousMetadata, 4, previousNonce, 0, 12);
            SecretKey previousDek = this.dek(EncryptionUtil.getInt(previousMetadata, 0));
            previousEncryptedRefName = this.encrypt(previousDek, previousNonce, refNameBytes, 0, refNameBytes.length);
        }
        this.encryptionStorageManager.putObjectId(metadataKey, metadata, encryptedRefName, encryptedId, previousEncryptedRefName);
        return desiredResult;
    }

    @VisibleForTesting
    public byte[] refMetadataKey(byte[] refNameBytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.refsKeyPrefix.length + refNameBytes.length);
        byteBuffer.put(this.refsKeyPrefix);
        byteBuffer.put(refNameBytes);
        return byteBuffer.array();
    }

    void deleteRef(String refName) {
        byte[] refNameBytes = refName.getBytes(StandardCharsets.UTF_8);
        byte[] metadataKey = this.refMetadataKey(refNameBytes);
        byte[] metadata = this.encryptionStorageManager.getMetadata(metadataKey);
        if (metadata == null) {
            return;
        }
        byte[] nonce = new byte[12];
        System.arraycopy(metadata, 4, nonce, 0, 12);
        int keyVersion = EncryptionUtil.getInt(metadata, 0);
        SecretKey dek = this.dek(keyVersion);
        byte[] encryptedRefName = this.encrypt(dek, nonce, refNameBytes, 0, refNameBytes.length);
        this.encryptionStorageManager.deleteObjectId(metadataKey, encryptedRefName);
    }

    void linkRef(String refName, String target) {
        byte[] refNameBytes = refName.getBytes(StandardCharsets.UTF_8);
        byte[] metadataKey = this.refMetadataKey(refNameBytes);
        byte[] nonce = AesGcmSivCipher.generateNonce();
        byte[] metadata = new byte[16];
        SecretKeyWithVersion currentDek = this.currentDek;
        EncryptionUtil.putInt(metadata, 0, currentDek.version());
        System.arraycopy(nonce, 0, metadata, 4, 12);
        byte[] encryptedRefName = this.encrypt(currentDek.secretKey(), nonce, refNameBytes, 0, refNameBytes.length);
        byte[] encoded = Constants.encode((String)("ref: " + target));
        byte[] encryptedTarget = this.encrypt(currentDek.secretKey(), nonce, encoded, 0, encoded.length);
        this.encryptionStorageManager.putObjectId(metadataKey, metadata, encryptedRefName, encryptedTarget, null);
    }

    @VisibleForTesting
    public ObjectId getRevisionObjectId(Revision revision) {
        byte[] metadataKey = this.rev2ShaMetadataKey(revision);
        byte[] metadata = this.encryptionStorageManager.getMetadata(metadataKey);
        if (metadata == null) {
            throw new RevisionNotFoundException(revision);
        }
        int keyVersion = EncryptionUtil.getInt(metadata, 0);
        SecretKey dek = this.dek(keyVersion);
        byte[] nonce = new byte[12];
        System.arraycopy(metadata, 4, nonce, 0, 12);
        byte[] encryptedKey = this.encrypt(dek, nonce, Ints.toByteArray((int)revision.major()), 0, 4);
        byte[] value = this.encryptionStorageManager.getObjectId(encryptedKey, metadataKey);
        if (value == null) {
            throw new RevisionNotFoundException(revision);
        }
        byte[] raw = this.decrypt(dek, nonce, value);
        if (raw.length != 20) {
            throw new EncryptionStorageException("Corrupted commit ID for " + revision + " in " + this.projectName + '/' + this.repoName + ":  expected 20 bytes but got " + raw.length);
        }
        return ObjectId.fromRaw((byte[])raw);
    }

    @VisibleForTesting
    public byte[] rev2ShaMetadataKey(Revision revision) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.rev2ShaPrefix.length + 4);
        byteBuffer.put(this.rev2ShaPrefix);
        byteBuffer.putInt(revision.major());
        return byteBuffer.array();
    }

    void putRevisionObjectId(Revision revision, ObjectId objectId) {
        byte[] metadataKey = this.rev2ShaMetadataKey(revision);
        if (this.encryptionStorageManager.containsMetadata(metadataKey)) {
            throw new EncryptionStorageException("Revision already exists: " + revision + " in " + this.projectName + '/' + this.repoName);
        }
        SecretKeyWithVersion currentDek = this.currentDek;
        byte[] metadata = new byte[16];
        byte[] nonce = AesGcmSivCipher.generateNonce();
        EncryptionUtil.putInt(metadata, 0, currentDek.version());
        System.arraycopy(nonce, 0, metadata, 4, 12);
        byte[] encryptedRevision = this.encrypt(currentDek.secretKey(), nonce, Ints.toByteArray((int)revision.major()), 0, 4);
        byte[] encryptedId = this.encryptObjectId(currentDek.secretKey(), nonce, objectId);
        this.encryptionStorageManager.putObjectId(metadataKey, metadata, encryptedRevision, encryptedId, null);
    }

    private static final class DecryptedObjectLoader
    extends ObjectLoader {
        private final byte[] decrypted;
        private final int type;

        DecryptedObjectLoader(byte[] decrypted, int type) {
            this.decrypted = decrypted;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.decrypted.length;
        }

        public byte[] getCachedBytes() {
            return this.decrypted;
        }

        public ObjectStream openStream() {
            return new ObjectStream.SmallStream((ObjectLoader)this);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("type", this.type).add("size", this.decrypted.length).toString();
        }
    }
}

