/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.storage.repository.AbstractCacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableFindLatestRevCall
extends AbstractCacheableCall<Revision> {
    static final Revision EMPTY = new Revision(Integer.MIN_VALUE);
    static final Revision ENTRY_NOT_FOUND = new Revision(Integer.MIN_VALUE);
    private final Revision lastKnownRevision;
    private final Revision headRevision;
    private final String pathPattern;
    private final boolean errorOnEntryNotFound;
    private final int hashCode;

    CacheableFindLatestRevCall(Repository repo, Revision lastKnownRevision, Revision headRevision, String pathPattern, boolean errorOnEntryNotFound) {
        super(repo);
        this.lastKnownRevision = Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        this.headRevision = Objects.requireNonNull(headRevision, "headRevision");
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.errorOnEntryNotFound = errorOnEntryNotFound;
        this.hashCode = Objects.hash(lastKnownRevision, headRevision, pathPattern, errorOnEntryNotFound) + System.identityHashCode(repo);
        assert (!lastKnownRevision.isRelative());
    }

    @Override
    public int weigh(Revision value) {
        return this.pathPattern.length();
    }

    @Override
    public CompletableFuture<Revision> execute() {
        RepositoryCache.logger.debug("Cache miss: {}", (Object)this);
        return this.repo().findLatestRevision(this.lastKnownRevision, this.pathPattern, this.errorOnEntryNotFound).handle((revision, cause) -> {
            if (cause != null) {
                if ((cause = Exceptions.peel((Throwable)cause)) instanceof EntryNotFoundException) {
                    return ENTRY_NOT_FOUND;
                }
                return (Revision)Exceptions.throwUnsafely((Throwable)cause);
            }
            return (Revision)MoreObjects.firstNonNull((Object)revision, (Object)EMPTY);
        });
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableFindLatestRevCall that = (CacheableFindLatestRevCall)o;
        return this.lastKnownRevision.equals((Object)that.lastKnownRevision) && this.headRevision.equals((Object)that.headRevision) && this.pathPattern.equals(that.pathPattern) && this.errorOnEntryNotFound == that.errorOnEntryNotFound;
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("lastKnownRevision", (Object)this.lastKnownRevision).add("headRevision", (Object)this.headRevision).add("pathPattern", (Object)this.pathPattern).add("errorOnEntryNotFound", this.errorOnEntryNotFound);
    }
}

