/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.HasId;
import com.linecorp.centraldogma.server.internal.storage.repository.HasRevision;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface CrudRepository<T> {
    public CompletableFuture<HasRevision<T>> save(String var1, T var2, Author var3, String var4);

    default public CompletableFuture<HasRevision<T>> save(String id, T entity, Author author) {
        return this.save(id, entity, author, "Create '" + id + '\'');
    }

    default public CompletableFuture<HasRevision<T>> save(String id, T entity) {
        return this.save(id, entity, AuthUtil.currentAuthor());
    }

    default public CompletableFuture<HasRevision<T>> save(HasId<T> entity) {
        return this.save(entity, AuthUtil.currentAuthor());
    }

    default public CompletableFuture<HasRevision<T>> save(HasId<T> entity, Author author) {
        return this.save(entity.id(), entity.object(), author);
    }

    default public CompletableFuture<HasRevision<T>> update(String id, T entity, Author author, String description) {
        return this.find(id).thenCompose(old -> {
            if (old == null) {
                throw new EntryNotFoundException("Cannot update a non-existent entity. (ID: " + id + ')');
            }
            return this.save(id, entity, author, description);
        });
    }

    default public CompletableFuture<HasRevision<T>> update(String id, T entity, Author author) {
        return this.update(id, entity, author, "Update '" + id + '\'');
    }

    default public CompletableFuture<HasRevision<T>> update(String id, T entity) {
        return this.update(id, entity, AuthUtil.currentAuthor());
    }

    default public CompletableFuture<HasRevision<T>> update(HasId<T> entity, Author author) {
        return this.update(entity.id(), entity.object(), author);
    }

    default public CompletableFuture<HasRevision<T>> update(HasId<T> entity) {
        return this.update(entity, AuthUtil.currentAuthor());
    }

    public CompletableFuture<HasRevision<T>> find(String var1);

    public CompletableFuture<List<HasRevision<T>>> findAll();

    public CompletableFuture<Revision> delete(String var1, Author var2, String var3);

    default public CompletableFuture<Revision> delete(String id, Author author) {
        return this.delete(id, author, "Delete '" + id + '\'');
    }

    default public CompletableFuture<Revision> delete(String id) {
        return this.delete(id, AuthUtil.currentAuthor());
    }
}

