/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Streams;
import com.linecorp.centraldogma.server.internal.api.sysadmin.MirrorAccessControlRequest;
import com.linecorp.centraldogma.server.internal.mirror.MirrorAccessControl;
import com.linecorp.centraldogma.server.internal.mirror.UuidGenerator;
import com.linecorp.centraldogma.server.internal.storage.repository.CrudRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.HasRevision;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.mirror.MirrorAccessController;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMirrorAccessController
implements MirrorAccessController {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMirrorAccessController.class);
    private static final UuidGenerator idGenerator = new UuidGenerator();
    @Nullable
    private CrudRepository<MirrorAccessControl> repository;

    public void setRepository(CrudRepository<MirrorAccessControl> repository) {
        Preconditions.checkState((this.repository == null ? 1 : 0) != 0, (Object)"repository is already set.");
        this.repository = repository;
    }

    private CrudRepository<MirrorAccessControl> repository() {
        Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"repository is not set.");
        return this.repository;
    }

    public CompletableFuture<MirrorAccessControl> add(MirrorAccessControlRequest request, Author author) {
        return this.repository().save(MirrorAccessControl.from(request, author), author).thenApply(HasRevision::object);
    }

    public CompletableFuture<MirrorAccessControl> update(MirrorAccessControlRequest request, Author author) {
        return this.repository().update(MirrorAccessControl.from(request, author), author).thenApply(HasRevision::object);
    }

    public CompletableFuture<MirrorAccessControl> get(String id) {
        return this.repository().find(id).thenApply(HasRevision::object);
    }

    public CompletableFuture<List<MirrorAccessControl>> list() {
        return this.repository().findAll().thenApply(list -> (List)list.stream().map(HasRevision::object).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public CompletableFuture<Boolean> allow(String targetPattern, String reason, int order) {
        Author author = Author.SYSTEM;
        MirrorAccessControl accessControl = new MirrorAccessControl(idGenerator.generateId().toString(), targetPattern, true, reason, order, UserAndTimestamp.of(author));
        logger.info("Allowing the target pattern: {}", (Object)accessControl);
        return this.repository().save(accessControl, author).thenApply(unused -> true);
    }

    @Override
    public CompletableFuture<Boolean> disallow(String targetPattern, String reason, int order) {
        Author author = Author.SYSTEM;
        MirrorAccessControl accessControl = new MirrorAccessControl(idGenerator.generateId().toString(), targetPattern, false, reason, order, UserAndTimestamp.of(author));
        logger.info("Disallowing the target pattern: {}", (Object)accessControl);
        return this.repository().save(accessControl, author).thenApply(unused -> true);
    }

    @Override
    public CompletableFuture<Boolean> isAllowed(String repoUri) {
        return this.repository().findAll().thenApply(acl -> {
            if (acl.isEmpty()) {
                return true;
            }
            List sorted = (List)acl.stream().sorted(AccessControlComparator.INSTANCE).collect(ImmutableList.toImmutableList());
            for (HasRevision entity : sorted) {
                try {
                    if (!DefaultMirrorAccessController.matchesRepoUri(repoUri, entity)) continue;
                    return ((MirrorAccessControl)entity.object()).allow();
                }
                catch (Exception e) {
                    logger.warn("Failed to match the target pattern: {}", (Object)((MirrorAccessControl)entity.object()).targetPattern(), (Object)e);
                }
            }
            return true;
        });
    }

    @Override
    public CompletableFuture<Map<String, Boolean>> isAllowed(Iterable<String> repoUris) {
        return this.repository().findAll().thenApply(acl -> {
            if (acl.isEmpty()) {
                return (Map)Streams.stream((Iterable)repoUris).distinct().collect(ImmutableMap.toImmutableMap(uri -> uri, uri -> true));
            }
            List sorted = (List)acl.stream().sorted(AccessControlComparator.INSTANCE).collect(ImmutableList.toImmutableList());
            return (Map)Streams.stream((Iterable)repoUris).distinct().collect(ImmutableMap.toImmutableMap(uri -> uri, uri -> {
                for (HasRevision entity : sorted) {
                    if (!DefaultMirrorAccessController.matchesRepoUri(uri, entity)) continue;
                    return ((MirrorAccessControl)entity.object()).allow();
                }
                return true;
            }));
        });
    }

    private static boolean matchesRepoUri(String repoUri, HasRevision<MirrorAccessControl> entity) {
        String targetPattern = entity.object().targetPattern();
        try {
            return repoUri.equals(targetPattern) || repoUri.matches(targetPattern);
        }
        catch (Exception e) {
            logger.warn("Failed to match the target pattern: {}", (Object)targetPattern, (Object)e);
            return false;
        }
    }

    public CompletableFuture<Void> delete(String id, Author author) {
        return this.repository().delete(id, author, "Delete '" + id + '\'').thenAccept(unused -> {});
    }

    private static enum AccessControlComparator implements Comparator<HasRevision<MirrorAccessControl>>
    {
        INSTANCE;


        @Override
        public int compare(HasRevision<MirrorAccessControl> o1, HasRevision<MirrorAccessControl> o2) {
            int result = Integer.compare(o1.object().order(), o2.object().order());
            if (result != 0) {
                return result;
            }
            return o2.object().creation().timestamp().compareTo(o1.object().creation().timestamp());
        }
    }
}

