/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.metadata.User;
import io.netty.util.AttributeKey;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpApiUtil {
    private static final AttributeKey<Boolean> VERBOSE_RESPONSES = AttributeKey.valueOf(HttpApiUtil.class, (String)"VERBOSE_RESPONSES");
    private static final Logger logger = LoggerFactory.getLogger(HttpApiUtil.class);
    private static final String ERROR_MESSAGE_FORMAT = "{} Returning a {} response: {}";
    static final JsonNode unremoveRequest = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"active")));

    public static <T> T throwResponse(ServiceRequestContext ctx, HttpStatus status, String message) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, message));
    }

    public static <T> T throwResponse(ServiceRequestContext ctx, HttpStatus status, String format, Object ... args) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, format, args));
    }

    public static <T> T throwResponse(ServiceRequestContext ctx, HttpStatus status, Throwable cause, String message) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, cause, message));
    }

    public static <T> T throwResponse(ServiceRequestContext ctx, HttpStatus status, Throwable cause, String format, Object ... args) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, cause, format, args));
    }

    public static HttpResponse newResponse(ServiceRequestContext ctx, HttpStatus status, String format, Object ... args) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return HttpApiUtil.newResponse(ctx, status, String.format(Locale.ENGLISH, format, args));
    }

    public static HttpResponse newResponse(ServiceRequestContext ctx, HttpStatus status, String message) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(message, "message");
        return HttpApiUtil.newResponse0(ctx, status, null, message);
    }

    public static HttpResponse newResponse(ServiceRequestContext ctx, HttpStatus status, Throwable cause) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(cause, "cause");
        return HttpApiUtil.newResponse0(ctx, status, cause, null);
    }

    public static HttpResponse newResponse(ServiceRequestContext ctx, ResponseHeaders headers, Throwable cause) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(cause, "cause");
        return HttpApiUtil.newResponse0(ctx, headers.toBuilder(), cause, null);
    }

    public static HttpResponse newResponse(ServiceRequestContext ctx, HttpStatus status, Throwable cause, String format, Object ... args) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(cause, "cause");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return HttpApiUtil.newResponse(ctx, status, cause, String.format(Locale.ENGLISH, format, args));
    }

    public static HttpResponse newResponse(ServiceRequestContext ctx, HttpStatus status, Throwable cause, String message) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(cause, "cause");
        Objects.requireNonNull(message, "message");
        return HttpApiUtil.newResponse0(ctx, status, cause, message);
    }

    public static AggregatedHttpResponse newAggregatedResponse(@Nullable ServiceRequestContext ctx, HttpStatus status, @Nullable Throwable cause, @Nullable String message) {
        Objects.requireNonNull(status, "status");
        return HttpApiUtil.newResponse1(AggregatedHttpResponse::of, ctx, ResponseHeaders.builder((HttpStatus)status), cause, message);
    }

    private static HttpResponse newResponse0(ServiceRequestContext ctx, HttpStatus status, @Nullable Throwable cause, @Nullable String message) {
        ResponseHeadersBuilder headersBuilder = ResponseHeaders.builder((HttpStatus)status);
        return HttpApiUtil.newResponse1(HttpResponse::of, ctx, headersBuilder, cause, message);
    }

    private static HttpResponse newResponse0(ServiceRequestContext ctx, ResponseHeadersBuilder headersBuilder, @Nullable Throwable cause, @Nullable String message) {
        return HttpApiUtil.newResponse1(HttpResponse::of, ctx, headersBuilder, cause, message);
    }

    private static <O> O newResponse1(BiFunction<ResponseHeaders, HttpData, O> responseFactory, @Nullable ServiceRequestContext ctx, ResponseHeadersBuilder headersBuilder, @Nullable Throwable cause, @Nullable String message) {
        LogLevel logLevel;
        HttpStatus status = headersBuilder.status();
        if (status.isContentAlwaysEmpty()) {
            Preconditions.checkArgument((message == null || message.isEmpty() ? 1 : 0) != 0, (String)"message: %s (expected: null or empty for a status with empty content)", (Object)message);
            return responseFactory.apply(headersBuilder.build(), HttpData.empty());
        }
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (cause != null) {
            cause = Exceptions.peel((Throwable)cause);
            node.put("exception", cause.getClass().getName());
            if (message == null) {
                message = cause.getMessage();
            }
        }
        String m = Strings.nullToEmpty((String)message);
        node.put("message", m);
        if (cause != null && HttpApiUtil.isVerboseResponse(ctx)) {
            node.put("detail", Exceptions.traceText((Throwable)cause));
        }
        switch (status.codeClass()) {
            case SERVER_ERROR: {
                if (cause != null) {
                    if (!Exceptions.isStreamCancelling((Throwable)cause) && !(cause instanceof ShuttingDownException)) {
                        logLevel = LogLevel.WARN;
                        break;
                    }
                    logLevel = null;
                    break;
                }
                logLevel = LogLevel.WARN;
                break;
            }
            case CLIENT_ERROR: {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case UNKNOWN: {
                logLevel = LogLevel.WARN;
                break;
            }
            default: {
                logLevel = null;
            }
        }
        if (logLevel != null) {
            if (logLevel == LogLevel.WARN) {
                if (cause != null) {
                    logger.warn(ERROR_MESSAGE_FORMAT, new Object[]{ctx, status, m, cause});
                } else {
                    logger.warn(ERROR_MESSAGE_FORMAT, new Object[]{ctx, status, m});
                }
            } else if (cause != null) {
                logger.debug(ERROR_MESSAGE_FORMAT, new Object[]{ctx, status, m, cause});
            } else {
                logger.debug(ERROR_MESSAGE_FORMAT, new Object[]{ctx, status, m});
            }
        }
        try {
            headersBuilder.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            ResponseHeaders headers = headersBuilder.contentType(MediaType.JSON_UTF_8).build();
            return responseFactory.apply(headers, HttpData.wrap((byte[])Jackson.writeValueAsBytes((Object)node)));
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    static void checkUnremoveArgument(JsonNode node) {
        Preconditions.checkArgument((boolean)unremoveRequest.equals((Object)node), (Object)("Unsupported JSON patch: " + node + " (expected: " + unremoveRequest + ')'));
    }

    static void checkStatusArgument(String status) {
        Preconditions.checkArgument((boolean)"removed".equalsIgnoreCase(status), (Object)("invalid status: " + status + " (expected: removed)"));
    }

    static Void throwUnsafelyIfNonNull(@Nullable Object unused, @Nullable Throwable cause) {
        HttpApiUtil.throwUnsafelyIfNonNull(cause);
        return null;
    }

    public static void throwUnsafelyIfNonNull(@Nullable Throwable cause) {
        if (cause != null) {
            Exceptions.throwUnsafely((Throwable)cause);
        }
    }

    static <T, U> BiFunction<? super T, Throwable, ? extends U> returnOrThrow(Supplier<? super U> supplier) {
        return (unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return supplier.get();
        };
    }

    static <T, U> BiFunction<? super T, Throwable, ? extends U> returnOrThrow(Function<? super T, ? extends U> function) {
        return (result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return function.apply(result);
        };
    }

    public static void setVerboseResponses(ServiceRequestContext ctx, User user) {
        ctx.setAttr(VERBOSE_RESPONSES, (Object)(Flags.verboseResponses() || user.isSystemAdmin() ? 1 : 0));
    }

    private static boolean isVerboseResponse(@Nullable ServiceRequestContext ctx) {
        if (ctx == null) {
            return false;
        }
        Boolean verboseResponses = (Boolean)ctx.attr(VERBOSE_RESPONSES);
        return (Boolean)MoreObjects.firstNonNull((Object)verboseResponses, (Object)false);
    }

    private HttpApiUtil() {
    }
}

