/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.ByteStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Header;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.centraldogma.common.RepositoryRole;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRepositoryRole;
import com.linecorp.centraldogma.server.internal.api.converter.HttpApiRequestConverter;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectApiManager;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.UploadPack;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestConverter(value=HttpApiRequestConverter.class)
@RequiresRepositoryRole(value=RepositoryRole.READ)
public final class GitHttpService {
    private static final Logger logger = LoggerFactory.getLogger(GitHttpService.class);
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final AggregatedHttpResponse CAPABILITY_ADVERTISEMENT_RESPONSE = AggregatedHttpResponse.of((ResponseHeaders)ResponseHeaders.builder((int)200).contentType(MediaType.GIT_UPLOAD_PACK_ADVERTISEMENT).add((CharSequence)HttpHeaderNames.CACHE_CONTROL, ServerCacheControl.REVALIDATED.asHeaderValue()).build(), (HttpData)HttpData.ofUtf8((String)GitHttpService.capabilityAdvertisement()));
    private final ProjectApiManager projectApiManager;

    private static String capabilityAdvertisement() {
        PacketLineFraming packetLineFraming = new PacketLineFraming();
        packetLineFraming.putWithoutPktLine("001e# service=git-upload-pack\n");
        packetLineFraming.flush();
        packetLineFraming.put("version 2");
        packetLineFraming.put("ls-refs");
        packetLineFraming.put("fetch=wait-for-done shallow");
        packetLineFraming.put("object-format=sha1");
        packetLineFraming.flush();
        return packetLineFraming.toString();
    }

    public GitHttpService(ProjectApiManager projectApiManager) {
        this.projectApiManager = Objects.requireNonNull(projectApiManager, "projectApiManager");
    }

    @Get(value="/{projectName}/{repoName}/info/refs")
    public HttpResponse advertiseCapability(@Header(value="git-protocol") @Nullable String gitProtocol, @Param String service, @Param String projectName, @Param String repoName, User user) {
        repoName = GitHttpService.maybeRemoveGitSuffix(repoName);
        if (!"git-upload-pack".equals(service)) {
            return HttpResponse.of((HttpStatus)HttpStatus.FORBIDDEN, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Unsupported service: " + service));
        }
        if (gitProtocol == null || !gitProtocol.contains("version=2")) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Unsupported git-protocol: " + gitProtocol));
        }
        if (!this.projectApiManager.exists(projectName)) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Project not found: " + projectName));
        }
        if (!this.projectApiManager.getProject(projectName, user).repos().exists(repoName)) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Repository not found: " + repoName));
        }
        return CAPABILITY_ADVERTISEMENT_RESPONSE.toHttpResponse();
    }

    private static String maybeRemoveGitSuffix(String repoName) {
        if (repoName.length() >= 5 && repoName.endsWith(".git")) {
            repoName = repoName.substring(0, repoName.length() - 4);
        }
        return repoName;
    }

    @Post(value="/{projectName}/{repoName}/git-upload-pack")
    public HttpResponse gitUploadPack(AggregatedHttpRequest req, @Param String projectName, @Param String repoName, User user) {
        repoName = GitHttpService.maybeRemoveGitSuffix(repoName);
        String gitProtocol = req.headers().get((CharSequence)HttpHeaderNames.GIT_PROTOCOL);
        if (gitProtocol == null || !gitProtocol.contains("version=2")) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Unsupported git-protocol: " + gitProtocol));
        }
        MediaType contentType = req.headers().contentType();
        if (MediaType.GIT_UPLOAD_PACK_REQUEST != contentType) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Unsupported content-type: " + contentType));
        }
        if (!this.projectApiManager.exists(projectName)) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Project not found: " + projectName));
        }
        Project project = this.projectApiManager.getProject(projectName, user);
        if (!project.repos().exists(repoName)) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)("Repository not found: " + repoName));
        }
        Repository jGitRepository = ((com.linecorp.centraldogma.server.storage.repository.Repository)project.repos().get(repoName)).jGitRepository();
        ByteStreamMessage body = StreamMessage.fromOutputStream(os -> {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(req.content().byteBuf().array());
            UploadPack uploadPack = new UploadPack(jGitRepository);
            uploadPack.setTimeout(0);
            uploadPack.setBiDirectionalPipe(false);
            uploadPack.setExtraParameters((Collection)ImmutableList.of((Object)"version=2"));
            try {
                uploadPack.upload((InputStream)inputStream, os, null);
            }
            catch (IOException e) {
                logger.debug("Failed to respond git-upload-pack-request: {}", (Object)req.contentUtf8(), (Object)e);
                throw new RuntimeException("failed to respond git-upload-pack-request: " + req.contentUtf8(), e);
            }
            try {
                os.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the output stream. request: {}", (Object)req.contentUtf8(), (Object)e);
            }
        });
        return HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((int)200).contentType(MediaType.GIT_UPLOAD_PACK_RESULT).add((CharSequence)HttpHeaderNames.CACHE_CONTROL, ServerCacheControl.REVALIDATED.asHeaderValue()).build(), (Publisher)body);
    }

    static class PacketLineFraming {
        private final StringBuilder sb = new StringBuilder();

        PacketLineFraming() {
        }

        void put(String line) {
            PacketLineFraming.lineLength(this.sb, line.getBytes(StandardCharsets.UTF_8).length + 5);
            this.sb.append(line).append('\n');
        }

        private static void lineLength(StringBuilder sb, int length) {
            for (int i = 3; i >= 0; --i) {
                sb.append(HEX_DIGITS[length >>> 4 * i & 0xF]);
            }
        }

        void putWithoutPktLine(String line) {
            this.sb.append(line);
        }

        void delim() {
            this.sb.append("0001");
        }

        void flush() {
            this.sb.append("0000");
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

