/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.ProjectCommand;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public final class MigrateToEncryptedRepositoryCommand
extends ProjectCommand<Void> {
    private final String repositoryName;
    private final byte[] wdek;

    @JsonCreator
    MigrateToEncryptedRepositoryCommand(@JsonProperty(value="timestamp") @Nullable Long timestamp, @JsonProperty(value="author") @Nullable Author author, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="repositoryName") String repositoryName, @JsonProperty(value="wdek") byte[] wdek) {
        super(CommandType.MIGRATE_TO_ENCRYPTED_REPOSITORY, timestamp, author, projectName);
        this.repositoryName = Objects.requireNonNull(repositoryName, "repositoryName");
        this.wdek = Objects.requireNonNull(wdek, "wdek");
        Preconditions.checkArgument((wdek.length > 0 ? 1 : 0) != 0, (Object)"wdek must not be empty");
    }

    @JsonProperty
    public String repositoryName() {
        return this.repositoryName;
    }

    @JsonProperty
    public byte[] wdek() {
        return (byte[])this.wdek.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MigrateToEncryptedRepositoryCommand)) {
            return false;
        }
        MigrateToEncryptedRepositoryCommand that = (MigrateToEncryptedRepositoryCommand)obj;
        return super.equals(obj) && this.repositoryName.equals(that.repositoryName) && Arrays.equals(this.wdek, that.wdek);
    }

    @Override
    public int hashCode() {
        return (this.repositoryName.hashCode() * 31 + Arrays.hashCode(this.wdek)) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("repositoryName", (Object)this.repositoryName).add("wdek", (Object)"[***]");
    }
}

