/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRoleDecorator;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.MetadataServiceInjector;
import com.linecorp.centraldogma.server.metadata.Permission;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class RequiresPermissionDecorator
extends SimpleDecoratingHttpService {
    private final Permission requiredPermission;

    RequiresPermissionDecorator(HttpService delegate, Permission requiredPermission) {
        super(delegate);
        this.requiredPermission = Objects.requireNonNull(requiredPermission, "requiredPermission");
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MetadataService mds = MetadataServiceInjector.getMetadataService(ctx);
        User user = AuthUtil.currentUser(ctx);
        String projectName = ctx.pathParam("projectName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"no project name is specified");
        String repoName = ctx.pathParam("repoName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repoName) ? 1 : 0) != 0, (Object)"no repository name is specified");
        if ("dogma".equals(repoName)) {
            if (!user.isAdmin()) {
                return RequiresPermissionDecorator.throwForbiddenResponse(ctx, projectName, repoName, "administrator");
            }
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        return this.serveUserRepo(ctx, req, mds, user, projectName, repoName);
    }

    private static HttpResponse throwForbiddenResponse(ServiceRequestContext ctx, String projectName, String repoName, String adminOrOwner) {
        return (HttpResponse)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "Repository '%s/%s' can be accessed only by an %s.", projectName, repoName, adminOrOwner);
    }

    private HttpResponse serveUserRepo(ServiceRequestContext ctx, HttpRequest req, MetadataService mds, User user, String projectName, String repoName) throws Exception {
        CompletableFuture<Collection<Permission>> f;
        try {
            f = mds.findPermissions(projectName, repoName, user);
        }
        catch (Throwable cause2) {
            return RequiresRoleDecorator.handleException(ctx, cause2);
        }
        return HttpResponse.of(f.handle((permission, cause) -> {
            if (cause != null) {
                return RequiresRoleDecorator.handleException(ctx, cause);
            }
            if (!permission.contains((Object)this.requiredPermission)) {
                return (HttpResponse)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "You must have %s permission for repository '%s/%s'.", new Object[]{this.requiredPermission, projectName, repoName});
            }
            try {
                return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
    }

    public static final class RequiresWritePermissionDecoratorFactory
    implements DecoratorFactoryFunction<RequiresWritePermission> {
        public Function<? super HttpService, ? extends HttpService> newDecorator(RequiresWritePermission parameter) {
            return delegate -> new RequiresPermissionDecorator((HttpService)delegate, Permission.WRITE);
        }
    }

    public static final class RequiresReadPermissionDecoratorFactory
    implements DecoratorFactoryFunction<RequiresReadPermission> {
        public Function<? super HttpService, ? extends HttpService> newDecorator(RequiresReadPermission parameter) {
            return delegate -> new RequiresPermissionDecorator((HttpService)delegate, Permission.READ);
        }
    }
}

