/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.dto;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.thrift.Revision;
import java.util.Objects;

public class RevisionDto {
    private final int major;
    private final int minor;
    private final String revisionNumber;

    public RevisionDto(Revision revision) {
        Objects.requireNonNull(revision, "revision");
        this.major = revision.getMajor();
        this.minor = revision.getMinor();
        this.revisionNumber = String.format("%d.%d", this.major, this.minor);
    }

    public RevisionDto(int major, int minor, String revisionNumber) {
        this.major = major;
        this.minor = minor;
        this.revisionNumber = Objects.requireNonNull(revisionNumber, "revisionNumber");
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("major", this.major).add("minor", this.minor).toString();
    }
}

