/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.function.Function;

public final class MetadataServiceInjector
extends SimpleDecoratingService<HttpRequest, HttpResponse> {
    private static final AttributeKey<MetadataService> METADATA_SERVICE_ATTRIBUTE_KEY = AttributeKey.valueOf(MetadataServiceInjector.class, (String)"METADATA");
    private final MetadataService mds;

    public static Function<Service<HttpRequest, HttpResponse>, MetadataServiceInjector> newDecorator(MetadataService mds) {
        Objects.requireNonNull(mds, "mds");
        return service -> new MetadataServiceInjector((Service<HttpRequest, HttpResponse>)service, mds);
    }

    private MetadataServiceInjector(Service<HttpRequest, HttpResponse> delegate, MetadataService mds) {
        super(delegate);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        ctx.attr(METADATA_SERVICE_ATTRIBUTE_KEY).set((Object)this.mds);
        return (HttpResponse)this.delegate().serve(ctx, (Request)req);
    }

    public static MetadataService getMetadataService(ServiceRequestContext ctx) {
        MetadataService mds = (MetadataService)ctx.attr(METADATA_SERVICE_ATTRIBUTE_KEY).get();
        if (mds != null) {
            return mds;
        }
        throw new IllegalStateException("No metadata service instance exists.");
    }
}

