/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresAdministrator;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.function.Function;

public final class RequiresAdministratorDecorator
extends SimpleDecoratingService<HttpRequest, HttpResponse> {
    RequiresAdministratorDecorator(Service<HttpRequest, HttpResponse> delegate) {
        super(delegate);
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        User user = AuthUtil.currentUser(ctx);
        if (user.isAdmin()) {
            return (HttpResponse)this.delegate().serve(ctx, (Request)req);
        }
        return (HttpResponse)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "You must be an administrator to perform this operation.");
    }

    public static final class RequiresAdministratorDecoratorFactory
    implements DecoratorFactoryFunction<RequiresAdministrator> {
        public Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> newDecorator(RequiresAdministrator parameter) {
            return RequiresAdministratorDecorator::new;
        }
    }
}

