/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth.saml;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.saml.SamlServiceProvider;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.auth.AllowedUrisConfig;
import com.linecorp.centraldogma.server.auth.AuthProvider;
import com.linecorp.centraldogma.server.auth.AuthProviderParameters;
import java.util.Objects;

public class SamlAuthProvider
implements AuthProvider {
    private final SamlServiceProvider sp;
    private final AuthProviderParameters parameters;

    SamlAuthProvider(SamlServiceProvider sp, AuthProviderParameters parameters) {
        this.sp = Objects.requireNonNull(sp, "sp");
        this.parameters = Objects.requireNonNull(parameters, "parameters");
    }

    public HttpService webLoginService(AllowedUrisConfig unused) {
        HttpService service = (ctx, req) -> HttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.FOUND).set((CharSequence)HttpHeaderNames.LOCATION, "/").set((CharSequence)HttpHeaderNames.CACHE_CONTROL, ServerCacheControl.DISABLED.asHeaderValue()).build());
        return (HttpService)service.decorate(this.sp.newSamlDecorator());
    }

    public Iterable<HttpServiceWithRoutes> moreServices() {
        return ImmutableList.of((Object)this.sp.newSamlService());
    }

    public AuthProviderParameters parameters() {
        return this.parameters;
    }
}

