/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth.saml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlNameIdFormat;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SamlAuthProperties {
    private static final String DEFAULT_SIGNING_KEY = "signing";
    private static final String DEFAULT_ENCRYPTION_KEY = "encryption";
    private final String entityId;
    private final String hostname;
    private final String signingKey;
    private final String encryptionKey;
    private final KeyStore keyStore;
    @Nullable
    private final Acs acs;
    private final Idp idp;
    private final boolean signatureRequired;

    @JsonCreator
    public SamlAuthProperties(@JsonProperty(value="entityId") String entityId, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="signingKey") @Nullable String signingKey, @JsonProperty(value="encryptionKey") @Nullable String encryptionKey, @JsonProperty(value="keyStore") KeyStore keyStore, @JsonProperty(value="acs") @Nullable Acs acs, @JsonProperty(value="idp") Idp idp) {
        this(entityId, hostname, signingKey, encryptionKey, keyStore, acs, idp, true);
    }

    @VisibleForTesting
    public SamlAuthProperties(String entityId, String hostname, @Nullable String signingKey, @Nullable String encryptionKey, KeyStore keyStore, @Nullable Acs acs, Idp idp, boolean signatureRequired) {
        this.entityId = Objects.requireNonNull(entityId, "entityId");
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        this.signingKey = (String)MoreObjects.firstNonNull((Object)signingKey, (Object)DEFAULT_SIGNING_KEY);
        this.encryptionKey = (String)MoreObjects.firstNonNull((Object)encryptionKey, (Object)DEFAULT_ENCRYPTION_KEY);
        this.keyStore = Objects.requireNonNull(keyStore, "keyStore");
        this.acs = acs;
        this.idp = Objects.requireNonNull(idp, "idp");
        this.signatureRequired = signatureRequired;
    }

    @JsonProperty
    String entityId() {
        return this.entityId;
    }

    @JsonProperty
    String hostname() {
        return this.hostname;
    }

    @JsonProperty
    String signingKey() {
        return this.signingKey;
    }

    @JsonProperty
    String encryptionKey() {
        return this.encryptionKey;
    }

    @JsonProperty
    KeyStore keyStore() {
        return this.keyStore;
    }

    @Nullable
    @JsonProperty
    Acs acs() {
        return this.acs;
    }

    @JsonProperty
    Idp idp() {
        return this.idp;
    }

    public boolean signatureRequired() {
        return this.signatureRequired;
    }

    public String toString() {
        try {
            return Jackson.writeValueAsPrettyString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class KeyStore {
        private static final String DEFAULT_SIGNATURE_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        private final String type;
        private final String path;
        @Nullable
        private final String password;
        @Nullable
        private final Map<String, String> keyPasswords;
        private final String signatureAlgorithm;

        @JsonCreator
        public KeyStore(@JsonProperty(value="type") @Nullable String type, @JsonProperty(value="path") String path, @JsonProperty(value="password") @Nullable String password, @JsonProperty(value="keyPasswords") @Nullable Map<String, String> keyPasswords, @JsonProperty(value="signatureAlgorithm") @Nullable String signatureAlgorithm) {
            this.type = (String)MoreObjects.firstNonNull((Object)type, (Object)java.security.KeyStore.getDefaultType());
            this.path = Objects.requireNonNull(path, "path");
            this.password = password;
            this.keyPasswords = keyPasswords;
            this.signatureAlgorithm = (String)MoreObjects.firstNonNull((Object)signatureAlgorithm, (Object)DEFAULT_SIGNATURE_ALGORITHM);
        }

        @JsonProperty
        String type() {
            return this.type;
        }

        @JsonProperty
        String path() {
            return this.path;
        }

        @Nullable
        @JsonProperty
        String password() {
            return CentralDogmaConfig.convertValue((String)this.password, (String)"keyStore.password");
        }

        @JsonProperty
        Map<String, String> keyPasswords() {
            return KeyStore.sanitizePasswords(this.keyPasswords);
        }

        private static Map<String, String> sanitizePasswords(@Nullable Map<String, String> keyPasswords) {
            if (keyPasswords == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            keyPasswords.forEach((key, password) -> builder.put(key, (Object)((String)MoreObjects.firstNonNull((Object)CentralDogmaConfig.convertValue((String)password, (String)"keyStore.keyPasswords"), (Object)""))));
            return builder.build();
        }

        @JsonProperty
        String signatureAlgorithm() {
            return this.signatureAlgorithm;
        }
    }

    public static class Acs {
        private final List<SamlEndpoint> endpoints;

        @JsonCreator
        public Acs(@JsonProperty(value="endpoints") List<SamlEndpoint> endpoints) {
            this.endpoints = Objects.requireNonNull(endpoints, "endpoints");
        }

        @JsonProperty
        List<SamlEndpoint> endpoints() {
            return this.endpoints;
        }
    }

    public static class Idp {
        private final String entityId;
        private final String uri;
        private final SamlBindingProtocol binding;
        private final String signingKey;
        private final String encryptionKey;
        @Nullable
        private final String subjectLoginNameIdFormat;
        @Nullable
        private final String attributeLoginName;

        @JsonCreator
        public Idp(@JsonProperty(value="entityId") String entityId, @JsonProperty(value="uri") String uri, @JsonProperty(value="binding") @Nullable String binding, @JsonProperty(value="signingKey") @Nullable String signingKey, @JsonProperty(value="encryptionKey") @Nullable String encryptionKey, @JsonProperty(value="subjectLoginNameIdFormat") @Nullable String subjectLoginNameIdFormat, @JsonProperty(value="attributeLoginName") @Nullable String attributeLoginName) {
            this.entityId = Objects.requireNonNull(entityId, "entityId");
            this.uri = Objects.requireNonNull(uri, "uri");
            this.binding = binding != null ? SamlBindingProtocol.valueOf((String)binding) : SamlBindingProtocol.HTTP_POST;
            this.signingKey = (String)MoreObjects.firstNonNull((Object)signingKey, (Object)entityId);
            this.encryptionKey = (String)MoreObjects.firstNonNull((Object)encryptionKey, (Object)entityId);
            if (subjectLoginNameIdFormat == null && attributeLoginName == null) {
                this.subjectLoginNameIdFormat = SamlNameIdFormat.EMAIL.urn();
                this.attributeLoginName = null;
            } else {
                this.subjectLoginNameIdFormat = subjectLoginNameIdFormat;
                this.attributeLoginName = attributeLoginName;
            }
        }

        @JsonProperty
        String entityId() {
            return this.entityId;
        }

        @JsonProperty
        String uri() {
            return this.uri;
        }

        @JsonProperty
        String binding() {
            return this.binding.name();
        }

        @JsonProperty
        String signingKey() {
            return this.signingKey;
        }

        @JsonProperty
        String encryptionKey() {
            return this.encryptionKey;
        }

        @Nullable
        @JsonProperty
        String subjectLoginNameIdFormat() {
            return this.subjectLoginNameIdFormat;
        }

        @Nullable
        @JsonProperty
        String attributeLoginName() {
            return this.attributeLoginName;
        }

        SamlEndpoint endpoint() {
            switch (this.binding) {
                case HTTP_POST: {
                    return SamlEndpoint.ofHttpPost((String)this.uri);
                }
                case HTTP_REDIRECT: {
                    return SamlEndpoint.ofHttpRedirect((String)this.uri);
                }
            }
            throw new IllegalStateException("Failed to get an endpoint of the IdP: " + this.entityId);
        }
    }
}

