/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth.saml;

final class HtmlUtil {
    private static final String HTML_HEAD_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\" />";
    private static final String HTML_HEAD_END_BODY_START = "</head><body onload=\"";
    private static final String END = "\"></body></html>";

    static String getHtmlWithCsrfAndRedirect(String csrfToken, String redirectScript) {
        StringBuilder sb = new StringBuilder(HTML_HEAD_START);
        sb.append(String.format("<meta name=\"csrf-token\" content=\"%s\" />", csrfToken));
        sb.append(HTML_HEAD_END_BODY_START);
        sb.append(redirectScript);
        if (!redirectScript.endsWith(";")) {
            sb.append(';');
        }
        sb.append(END);
        return sb.toString();
    }

    private HtmlUtil() {
    }
}

