/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.armeria.xds;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.linecorp.armeria.client.ClientBuilder;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.encoding.DecodingClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.xds.XdsBootstrap;
import com.linecorp.armeria.xds.client.endpoint.XdsEndpointGroup;
import com.linecorp.centraldogma.client.AbstractCentralDogmaBuilder;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.armeria.ArmeriaClientConfigurator;
import com.linecorp.centraldogma.internal.client.ReplicationLagTolerantCentralDogma;
import com.linecorp.centraldogma.internal.client.armeria.ArmeriaCentralDogma;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import io.envoyproxy.envoy.config.bootstrap.v3.Bootstrap;
import io.envoyproxy.envoy.config.bootstrap.v3.ClusterManager;
import io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.ApiConfigSource;
import io.envoyproxy.envoy.config.core.v3.GrpcService;
import io.envoyproxy.envoy.config.core.v3.HeaderValue;
import io.envoyproxy.envoy.config.core.v3.Locality;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.config.core.v3.TransportSocket;
import io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.envoyproxy.envoy.config.endpoint.v3.Endpoint;
import io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@UnstableApi
public final class XdsCentralDogmaBuilder
extends AbstractCentralDogmaBuilder<XdsCentralDogmaBuilder> {
    private static final String BOOTSTRAP_CLUSTER_NAME = "centraldogma-bootstrap-cluster";
    @VisibleForTesting
    static final String DEFAULT_LISTENER_NAME = "centraldogma-listener";
    private ScheduledExecutorService blockingTaskExecutor = CommonPools.blockingTaskExecutor();
    private ClientFactory clientFactory = ClientFactory.ofDefault();
    private ArmeriaClientConfigurator clientConfigurator = cb -> {};
    private String listenerName = "centraldogma-listener";
    private Locality locality = Locality.getDefaultInstance();
    private String localClusterName = "";
    private Function<Bootstrap, XdsBootstrap> xdsBootstrapFactory = XdsBootstrap::of;

    public XdsCentralDogmaBuilder listenerName(String listenerName) {
        Objects.requireNonNull(listenerName, "listenerName");
        this.listenerName = listenerName;
        return this;
    }

    @UnstableApi
    public XdsCentralDogmaBuilder serviceZone(String serviceZone) {
        Objects.requireNonNull(serviceZone, "serviceZone");
        this.locality = Locality.newBuilder().setZone(serviceZone).build();
        return this;
    }

    @UnstableApi
    public XdsCentralDogmaBuilder localClusterName(String localClusterName) {
        Objects.requireNonNull(localClusterName, "localClusterName");
        this.localClusterName = localClusterName;
        return this;
    }

    public XdsCentralDogmaBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor) {
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.blockingTaskExecutor = blockingTaskExecutor;
        return this;
    }

    public XdsCentralDogmaBuilder clientConfigurator(ArmeriaClientConfigurator clientConfigurator) {
        this.clientConfigurator = Objects.requireNonNull(clientConfigurator, "clientConfigurator");
        return this;
    }

    public XdsCentralDogmaBuilder clientFactory(ClientFactory clientFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory");
        return this;
    }

    @VisibleForTesting
    XdsCentralDogmaBuilder xdsBoostrapFactory(Function<Bootstrap, XdsBootstrap> xdsBootstrapFactory) {
        this.xdsBootstrapFactory = Objects.requireNonNull(xdsBootstrapFactory, "xdsBootstrapFactory");
        return this;
    }

    public CentralDogma build() {
        XdsBootstrap xdsBootstrap = this.xdsBootstrap();
        XdsEndpointGroup endpointGroup = XdsEndpointGroup.of((String)this.listenerName, (XdsBootstrap)xdsBootstrap);
        String scheme = "none+" + (this.isUseTls() ? "https" : "http");
        ClientBuilder builder = this.newClientBuilder(scheme, (EndpointGroup)endpointGroup, cb -> cb.decorator(DecodingClient.newDecorator()), "/");
        int maxRetriesOnReplicationLag = this.maxNumRetriesOnReplicationLag();
        ScheduledExecutorService blockingTaskExecutor = this.blockingTaskExecutor;
        ArmeriaCentralDogma dogma = new ArmeriaCentralDogma(blockingTaskExecutor, (WebClient)builder.build(WebClient.class), this.accessToken(), () -> XdsCentralDogmaBuilder.lambda$build$2((EndpointGroup)endpointGroup, xdsBootstrap));
        if (maxRetriesOnReplicationLag <= 0) {
            return dogma;
        }
        return new ReplicationLagTolerantCentralDogma(blockingTaskExecutor, (CentralDogma)dogma, maxRetriesOnReplicationLag, this.retryIntervalOnReplicationLagMillis(), () -> {
            ClientRequestContext ctx = ClientRequestContext.currentOrNull();
            return ctx != null ? ctx.remoteAddress() : null;
        });
    }

    private ClientBuilder newClientBuilder(String scheme, EndpointGroup endpointGroup, Consumer<ClientBuilder> customizer, String path) {
        ClientBuilder builder = Clients.builder((String)scheme, (EndpointGroup)endpointGroup, (String)path);
        customizer.accept(builder);
        this.clientConfigurator.configure(builder);
        builder.factory(this.clientFactory);
        return builder;
    }

    private boolean isUnresolved() {
        Set hosts = this.hosts();
        Preconditions.checkState((!hosts.isEmpty() ? 1 : 0) != 0, (Object)"No hosts were added.");
        Map<Boolean, List<InetSocketAddress>> addrByUnresolved = hosts.stream().collect(Collectors.partitioningBy(InetSocketAddress::isUnresolved));
        Preconditions.checkState((addrByUnresolved.get(true).isEmpty() || addrByUnresolved.get(false).isEmpty() ? 1 : 0) != 0, (String)"Cannot mix resolved and unresolved hosts (%s)", addrByUnresolved);
        InetSocketAddress firstHost = (InetSocketAddress)Iterables.get((Iterable)this.hosts(), (int)0);
        return firstHost.isUnresolved();
    }

    private XdsBootstrap xdsBootstrap() {
        GrpcService grpcService = GrpcService.newBuilder().setEnvoyGrpc(GrpcService.EnvoyGrpc.newBuilder().setClusterName(BOOTSTRAP_CLUSTER_NAME)).addInitialMetadata(HeaderValue.newBuilder().setKey(HttpHeaderNames.AUTHORIZATION.toString()).setValue("Bearer " + this.accessToken())).build();
        ApiConfigSource apiConfigSource = ApiConfigSource.newBuilder().addGrpcServices(grpcService).setApiType(ApiConfigSource.ApiType.AGGREGATED_GRPC).build();
        Bootstrap.DynamicResources dynamicResources = Bootstrap.DynamicResources.newBuilder().setAdsConfig(apiConfigSource).build();
        Bootstrap bootstrap = Bootstrap.newBuilder().setClusterManager(ClusterManager.newBuilder().setLocalClusterName(this.localClusterName)).setDynamicResources(dynamicResources).setNode(Node.newBuilder().setLocality(this.locality)).setStaticResources(Bootstrap.StaticResources.newBuilder().addClusters(this.bootstrapCluster())).build();
        return this.xdsBootstrapFactory.apply(bootstrap);
    }

    private Cluster bootstrapCluster() {
        boolean isUnresolved = this.isUnresolved();
        Cluster.Builder clusterBuilder = Cluster.newBuilder();
        if (isUnresolved) {
            clusterBuilder.setType(Cluster.DiscoveryType.STRICT_DNS);
        } else {
            clusterBuilder.setType(Cluster.DiscoveryType.STATIC);
        }
        LocalityLbEndpoints.Builder localityLbEndpointsBuilder = LocalityLbEndpoints.newBuilder();
        for (InetSocketAddress addr : this.hosts()) {
            LbEndpoint lbEndpoint = XdsCentralDogmaBuilder.fromAddress(addr);
            localityLbEndpointsBuilder.addLbEndpoints(lbEndpoint);
        }
        ClusterLoadAssignment clusterLoadAssignment = ClusterLoadAssignment.newBuilder().addEndpoints(localityLbEndpointsBuilder.build()).build();
        if (this.isUseTls()) {
            clusterBuilder.setTransportSocket(TransportSocket.newBuilder().setName("envoy.transport_sockets.tls").setTypedConfig(Any.pack((Message)UpstreamTlsContext.getDefaultInstance())));
        }
        clusterBuilder.setLoadAssignment(clusterLoadAssignment).setName(BOOTSTRAP_CLUSTER_NAME);
        return clusterBuilder.build();
    }

    private static LbEndpoint fromAddress(InetSocketAddress addr) {
        String hostString = addr.getHostString();
        int port = addr.getPort();
        Address address = Address.newBuilder().setSocketAddress(SocketAddress.newBuilder().setAddress(hostString).setPortValue(port)).build();
        return LbEndpoint.newBuilder().setEndpoint(Endpoint.newBuilder().setAddress(address)).build();
    }

    private static /* synthetic */ void lambda$build$2(EndpointGroup endpointGroup, XdsBootstrap xdsBootstrap) {
        endpointGroup.close();
        xdsBootstrap.close();
    }
}

