/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.rxjava2;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class ObservableResponseConverterFunction
implements ResponseConverterFunction {
    private final ResponseConverterFunction responseConverter;
    @Nullable
    private final ExceptionHandlerFunction exceptionHandler;

    @Deprecated
    public ObservableResponseConverterFunction(ResponseConverterFunction responseConverter, ExceptionHandlerFunction exceptionHandler) {
        this.responseConverter = Objects.requireNonNull(responseConverter, "responseConverter");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    }

    public ObservableResponseConverterFunction(ResponseConverterFunction responseConverter) {
        this.responseConverter = Objects.requireNonNull(responseConverter, "responseConverter");
        this.exceptionHandler = null;
    }

    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType produceType) {
        Class clazz = ClassUtil.typeToClass((Type)ClassUtil.unwrapUnaryAsyncType((Type)returnType));
        if (clazz == null) {
            return null;
        }
        if (Maybe.class.isAssignableFrom(clazz) || Single.class.isAssignableFrom(clazz) || Completable.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (Observable.class.isAssignableFrom(clazz)) {
            return true;
        }
        return null;
    }

    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        if (result instanceof Observable) {
            return this.responseConverter.convertResponse(ctx, headers, (Object)((Observable)result).toFlowable(BackpressureStrategy.BUFFER), trailers);
        }
        if (result instanceof Maybe) {
            CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
            Disposable disposable = ((Maybe)result).subscribe(o -> future.complete(this.onSuccess(ctx, headers, o, trailers)), cause -> future.complete(this.onError(ctx, (Throwable)cause)), () -> future.complete(this.onSuccess(ctx, headers, null, trailers)));
            return ObservableResponseConverterFunction.respond(future, disposable);
        }
        if (result instanceof Single) {
            CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
            Disposable disposable = ((Single)result).subscribe(o -> future.complete(this.onSuccess(ctx, headers, o, trailers)), cause -> future.complete(this.onError(ctx, (Throwable)cause)));
            return ObservableResponseConverterFunction.respond(future, disposable);
        }
        if (result instanceof Completable) {
            CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
            Disposable disposable = ((Completable)result).subscribe(() -> future.complete(this.onSuccess(ctx, headers, null, trailers)), cause -> future.complete(this.onError(ctx, (Throwable)cause)));
            return ObservableResponseConverterFunction.respond(future, disposable);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private HttpResponse onSuccess(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) {
        try {
            return this.responseConverter.convertResponse(ctx, headers, result, trailers);
        }
        catch (Exception e) {
            return this.onError(ctx, e);
        }
    }

    private HttpResponse onError(ServiceRequestContext ctx, Throwable cause) {
        if (this.exceptionHandler == null) {
            return HttpResponse.ofFailure((Throwable)cause);
        }
        return this.exceptionHandler.handleException(ctx, ctx.request(), cause);
    }

    private static HttpResponse respond(CompletableFuture<HttpResponse> future, Disposable disposable) {
        HttpResponse response = HttpResponse.of(future);
        response.whenComplete().exceptionally(cause -> {
            disposable.dispose();
            return null;
        });
        return response;
    }
}

