/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.sbt.javaformatter;

import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.lightbend.sbt.javaformatter.JavaFormatter;
import com.lightbend.sbt.javaformatter.JavaFormatter$Analysis$;
import java.io.File;
import java.io.Serializable;
import sbt.internal.util.Init;
import sbt.internal.util.MessageOnlyException;
import sbt.io.FileFilter;
import sbt.io.RichFile$;
import sbt.package$;
import sbt.std.TaskStreams;
import sbt.util.CacheImplicits$;
import sbt.util.CacheStoreFactory;
import sbt.util.ChangeReport;
import sbt.util.FileInfo;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JavaFormatter$ {
    public static JavaFormatter$ MODULE$;

    static {
        new JavaFormatter$();
    }

    public void apply(Seq<File> sourceDirectories, FileFilter includeFilter, FileFilter excludeFilter, TaskStreams<Init.ScopedKey<?>> streams, CacheStoreFactory cacheStoreFactory, JavaFormatterOptions options) {
        List files = package$.MODULE$.filesToFinder(sourceDirectories).descendantsExcept(includeFilter, excludeFilter).get().toList();
        this.cachedFormatSources(cacheStoreFactory, (Seq<File>)files, (Logger)streams.log(), new Formatter(options));
    }

    public boolean check(File baseDir, Seq<File> sourceDirectories, FileFilter includeFilter, FileFilter excludeFilter, TaskStreams<Init.ScopedKey<?>> streams, CacheStoreFactory cacheStoreFactory, JavaFormatterOptions options) {
        List files = package$.MODULE$.filesToFinder(sourceDirectories).descendantsExcept(includeFilter, excludeFilter).get().toList();
        JavaFormatter.Analysis analysis = this.cachedCheckSources(cacheStoreFactory, baseDir, (Seq<File>)files, (Logger)streams.log(), new Formatter(options));
        return this.trueOrBoom(analysis);
    }

    private String plural(int i) {
        if (i == 1) {
            return "";
        }
        return "s";
    }

    private boolean trueOrBoom(JavaFormatter.Analysis analysis) {
        int failureCount = analysis.failedCheck().size();
        if (failureCount > 0) {
            throw new MessageOnlyException(new StringBuilder(23).append(failureCount).append(" file").append(this.plural(failureCount)).append(" must be formatted").toString());
        }
        return true;
    }

    private JavaFormatter.Analysis cachedCheckSources(CacheStoreFactory cacheStoreFactory, File baseDir, Seq<File> sources, Logger log, Formatter formatter) {
        return this.trackSourcesViaCache(cacheStoreFactory, sources, (Function2<ChangeReport<File>, JavaFormatter.Analysis, JavaFormatter.Analysis>)(Function2 & Serializable & scala.Serializable)(outDiff, prev) -> {
            Set updatedOrAdded;
            log.debug((Function0 & Serializable & scala.Serializable)() -> outDiff.toString());
            Set filesToCheck = updatedOrAdded = (Set)outDiff.modified().$amp((GenSet)outDiff.checked());
            Set prevFailed = (Set)prev.failedCheck().$amp((GenSet)outDiff.unmodified());
            prevFailed.foreach((Function1 & Serializable & scala.Serializable)file -> {
                JavaFormatter$.MODULE$.warnBadFormat((File)RichFile$.MODULE$.relativeTo$extension(package$.MODULE$.fileToRichFile(file), baseDir).getOrElse((Function0 & Serializable & scala.Serializable)() -> file), log);
                return BoxedUnit.UNIT;
            });
            JavaFormatter.Analysis result = MODULE$.checkSources(baseDir, (Seq<File>)filesToCheck.toList(), log, formatter);
            return prev.copy((Set<File>)((Set)result.failedCheck().$bar((GenSet)prevFailed)));
        });
    }

    private void warnBadFormat(File file, Logger log) {
        log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(file.toString()).append(" isn't formatted properly!").toString());
    }

    private JavaFormatter.Analysis checkSources(File baseDir, Seq<File> sources, Logger log, Formatter formatter) {
        if (sources.nonEmpty()) {
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Checking ").append(sources.size()).append(" Java source").append(MODULE$.plural(sources.size())).append("...").toString());
        }
        Set unformatted = ((TraversableOnce)this.withFormattedSources(sources, log, (Function3 & Serializable & scala.Serializable)(file, input, output) -> {
            boolean diff;
            String string = input;
            String string2 = output;
            boolean bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (diff = false);
            if (diff) {
                MODULE$.warnBadFormat((File)RichFile$.MODULE$.relativeTo$extension(package$.MODULE$.fileToRichFile(file), baseDir).getOrElse((Function0 & Serializable & scala.Serializable)() -> file), log);
                return new Some(file);
            }
            return None$.MODULE$;
        }, formatter).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toSet();
        return new JavaFormatter.Analysis((Set<File>)unformatted);
    }

    private void cachedFormatSources(CacheStoreFactory cacheStoreFactory, Seq<File> sources, Logger log, Formatter formatter) {
        this.trackSourcesViaCache(cacheStoreFactory, sources, (Function2<ChangeReport<File>, JavaFormatter.Analysis, JavaFormatter.Analysis>)(Function2 & Serializable & scala.Serializable)(outDiff, prev) -> {
            log.debug((Function0 & Serializable & scala.Serializable)() -> outDiff.toString());
            Set updatedOrAdded = (Set)outDiff.modified().$amp((GenSet)outDiff.checked());
            Set filesToFormat = (Set)updatedOrAdded.$bar(prev.failedCheck());
            if (filesToFormat.nonEmpty()) {
                log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Formatting ").append(filesToFormat.size()).append(" Java source").append(MODULE$.plural(filesToFormat.size())).append("...").toString());
                MODULE$.formatSources((Set<File>)filesToFormat, log, formatter);
            }
            return new JavaFormatter.Analysis((Set<File>)Predef$.MODULE$.Set().empty());
        });
    }

    private void formatSources(Set<File> sources, Logger log, Formatter formatter) {
        int cnt = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.withFormattedSources((Seq<File>)sources.toList(), log, (Function3 & Serializable & scala.Serializable)(file, input, output) -> BoxesRunTime.boxToInteger((int)JavaFormatter$.$anonfun$formatSources$1(file, input, output)), formatter).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Reformatted ").append(cnt).append(" Java source").append(MODULE$.plural(cnt)).toString());
    }

    private JavaFormatter.Analysis trackSourcesViaCache(CacheStoreFactory cacheStoreFactory, Seq<File> sources, Function2<ChangeReport<File>, JavaFormatter.Analysis, JavaFormatter.Analysis> f) {
        Function1 prevTracker = package$.MODULE$.Tracked().lastOutput(cacheStoreFactory.make("last"), (Function2 & Serializable & scala.Serializable)(x$2, prev0) -> {
            JavaFormatter.Analysis prev = (JavaFormatter.Analysis)prev0.getOrElse((Function0 & Serializable & scala.Serializable)() -> new JavaFormatter.Analysis((Set<File>)Predef$.MODULE$.Set().empty()));
            return (JavaFormatter.Analysis)package$.MODULE$.Tracked().diffOutputs(cacheStoreFactory.make("output-diff"), (FileInfo.Style)FileInfo.lastModified$.MODULE$).apply(sources.toSet(), (Function1 & Serializable & scala.Serializable)outDiff -> (JavaFormatter.Analysis)f.apply(outDiff, (Object)prev));
        }, CacheImplicits$.MODULE$.isolistFormat(JavaFormatter$Analysis$.MODULE$.analysisIso()));
        return (JavaFormatter.Analysis)prevTracker.apply((Object)BoxedUnit.UNIT);
    }

    private <T> Seq<Option<T>> withFormattedSources(Seq<File> sources, Logger log, Function3<File, String, String, T> onFormat, Formatter formatter) {
        return (Seq)sources.map((Function1 & Serializable & scala.Serializable)file -> {
            Some some;
            String input = package$.MODULE$.IO().read(file, package$.MODULE$.IO().read$default$2());
            try {
                String output = formatter.formatSourceAndFixImports(input);
                some = new Some(onFormat.apply(file, (Object)input, (Object)output));
            }
            catch (Exception e) {
                some = new Some(onFormat.apply(file, (Object)input, (Object)input));
            }
            return some;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ int $anonfun$formatSources$1(File file, String input, String output) {
        String string = input;
        String string2 = output;
        if (string == null ? string2 != null : !string.equals(string2)) {
            package$.MODULE$.IO().write(file, output, package$.MODULE$.IO().write$default$3(), package$.MODULE$.IO().write$default$4());
            return 1;
        }
        return 0;
    }

    private JavaFormatter$() {
        MODULE$ = this;
    }
}

