/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.plutonium.thymeleaf.portlet;

import jakarta.portlet.PortletSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebSession;

public class PortletIWebSession
implements IWebSession {
    private final PortletSession portletSession;

    public PortletIWebSession(PortletSession portletSession) {
        this.portletSession = portletSession;
    }

    public boolean exists() {
        return this.portletSession != null;
    }

    public boolean containsAttribute(String name) {
        return this.portletSession.getAttribute(name) != null;
    }

    public int getAttributeCount() {
        return this.getAllAttributeNames().size();
    }

    public Set<String> getAllAttributeNames() {
        if (this.portletSession == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        Enumeration attributeNames = this.portletSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            names.add((String)attributeNames.nextElement());
        }
        return names;
    }

    public Map<String, Object> getAttributeMap() {
        if (this.portletSession == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration attributeNames = this.portletSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            attributes.put(name, this.portletSession.getAttribute(name));
        }
        return attributes;
    }

    public Object getAttributeValue(String name) {
        return this.portletSession != null ? this.portletSession.getAttribute(name) : null;
    }

    public void setAttributeValue(String name, Object value) {
        if (this.portletSession != null) {
            this.portletSession.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (this.portletSession != null) {
            this.portletSession.removeAttribute(name);
        }
    }
}

