/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.plutonium.thymeleaf.portlet;

import com.liferay.plutonium.thymeleaf.portlet.PortletIWebApplication;
import com.liferay.plutonium.thymeleaf.portlet.PortletIWebRequest;
import com.liferay.plutonium.thymeleaf.portlet.PortletIWebSession;
import jakarta.portlet.ClientDataRequest;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletSession;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebApplication;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.IWebRequest;
import org.thymeleaf.web.IWebSession;

public class PortletIWebExchange
implements IWebExchange {
    private final PortletRequest portletRequest;

    public PortletIWebExchange(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
    }

    public IWebRequest getRequest() {
        return new PortletIWebRequest(this.portletRequest);
    }

    public IWebSession getSession() {
        PortletSession session = this.portletRequest.getPortletSession(true);
        return new PortletIWebSession(session);
    }

    public IWebApplication getApplication() {
        return new PortletIWebApplication(this.portletRequest.getPortletSession().getPortletContext());
    }

    public Principal getPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public Locale getLocale() {
        return this.portletRequest.getLocale();
    }

    public String getContentType() {
        return this.portletRequest.getResponseContentType();
    }

    public String getCharacterEncoding() {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDatRequest = (ClientDataRequest)this.portletRequest;
            return clientDatRequest.getCharacterEncoding();
        }
        throw new UnsupportedOperationException();
    }

    public boolean containsAttribute(String name) {
        return this.portletRequest.getAttribute(name) != null;
    }

    public int getAttributeCount() {
        Enumeration attributeNames = this.portletRequest.getAttributeNames();
        int count = 0;
        while (attributeNames.hasMoreElements()) {
            ++count;
            attributeNames.nextElement();
        }
        return count;
    }

    public Set<String> getAllAttributeNames() {
        Enumeration attributeNames = this.portletRequest.getAttributeNames();
        HashSet<String> attributeSet = new HashSet<String>();
        while (attributeNames.hasMoreElements()) {
            attributeSet.add((String)attributeNames.nextElement());
        }
        return attributeSet;
    }

    public Map<String, Object> getAttributeMap() {
        Enumeration attributeNames = this.portletRequest.getAttributeNames();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            attributeMap.put(name, this.portletRequest.getAttribute(name));
        }
        return Collections.unmodifiableMap(attributeMap);
    }

    public Object getAttributeValue(String name) {
        return this.portletRequest.getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        this.portletRequest.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.portletRequest.removeAttribute(name);
    }

    public String transformURL(String url) {
        return this.portletRequest.getContextPath() + url;
    }
}

