/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.DataHandlerFactory;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MIMEException;
import org.apache.axiom.mime.Part;
import org.apache.axiom.mime.PartImpl;
import org.apache.axiom.mime.PartIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;

public final class MultipartBody
implements Iterable<Part> {
    private static final Log log = LogFactory.getLog(MultipartBody.class);
    private static final MimeConfig config = MimeConfig.custom().setStrictParsing(true).build();
    private final ContentType contentType;
    private final String rootPartContentID;
    private final MimeTokenStream parser;
    private final Map<String, PartImpl> partMap = new HashMap<String, PartImpl>();
    private PartImpl currentPart;
    private PartImpl firstPart;
    private PartImpl rootPart;
    private int partCount;
    private final WritableBlobFactory<?> attachmentBlobFactory;
    private final DataHandlerFactory dataHandlerFactory;
    private final PartCreationListener partCreationListener;

    MultipartBody(InputStream inStream, ContentType contentType, WritableBlobFactory<?> attachmentBlobFactory, DataHandlerFactory dataHandlerFactory, PartCreationListener partCreationListener) {
        this.attachmentBlobFactory = attachmentBlobFactory;
        this.dataHandlerFactory = dataHandlerFactory;
        this.partCreationListener = partCreationListener;
        this.contentType = contentType;
        String start = contentType.getParameter("start");
        this.rootPartContentID = start == null ? null : MultipartBody.normalizeContentID(start);
        this.parser = new MimeTokenStream(config);
        this.parser.setRecursionMode(RecursionMode.M_NO_RECURSE);
        this.parser.parseHeadless(inStream, contentType.toString());
        while (this.parser.getState() != EntityState.T_START_BODYPART) {
            try {
                this.parser.next();
            }
            catch (IOException ex) {
                throw new MIMEException(ex);
            }
            catch (MimeException ex) {
                throw new MIMEException(ex);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String normalizeContentID(String contentID) {
        if ((contentID = contentID.trim()).length() >= 2 && contentID.charAt(0) == '<' && contentID.charAt(contentID.length() - 1) == '>') {
            contentID = contentID.substring(1, contentID.length() - 1);
        }
        if (contentID.length() > 4 && contentID.startsWith("cid:")) {
            contentID = contentID.substring(4);
        }
        return contentID;
    }

    DataHandlerFactory getDataHandlerFactory() {
        return this.dataHandlerFactory;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Part getPart(String contentID) {
        do {
            PartImpl part;
            if ((part = this.partMap.get(contentID)) == null) continue;
            return part;
        } while (this.getNextPart() != null);
        return null;
    }

    public int getPartCount() {
        this.detach();
        return this.partCount;
    }

    PartImpl getFirstPart() {
        if (this.firstPart == null) {
            this.getNextPart();
        }
        return this.firstPart;
    }

    public Part getRootPart() {
        do {
            if (this.rootPart == null) continue;
            return this.rootPart;
        } while (this.getNextPart() != null);
        throw new MIMEException("Mandatory root MIME part is missing");
    }

    PartImpl getNextPart() {
        if (this.currentPart != null) {
            this.currentPart.fetch();
        }
        if (this.parser.getState() == EntityState.T_END_MULTIPART) {
            this.currentPart = null;
        } else {
            boolean isRootPart;
            String partContentID = null;
            try {
                MultipartBody.checkParserState(this.parser.next(), EntityState.T_START_HEADER);
                ArrayList<Header> headers = new ArrayList<Header>();
                while (this.parser.next() == EntityState.T_FIELD) {
                    Field field = this.parser.getField();
                    String name = field.getName();
                    String value = field.getBody();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("addHeader: (" + name + ") value=(" + value + ")"));
                    }
                    headers.add(new Header(name, value));
                    if (partContentID != null || !name.equalsIgnoreCase("Content-ID")) continue;
                    partContentID = MultipartBody.normalizeContentID(value);
                }
                MultipartBody.checkParserState(this.parser.next(), EntityState.T_BODY);
                isRootPart = this.rootPartContentID == null ? this.firstPart == null : this.rootPartContentID.equals(partContentID);
                PartImpl part = new PartImpl(this, isRootPart ? MemoryBlob.FACTORY : this.attachmentBlobFactory, partContentID, headers, this.parser);
                if (this.currentPart == null) {
                    this.firstPart = part;
                } else {
                    this.currentPart.setNextPart(part);
                }
                this.currentPart = part;
            }
            catch (IOException ex) {
                throw new MIMEException(ex);
            }
            catch (MimeException ex) {
                throw new MIMEException(ex);
            }
            ++this.partCount;
            if (partContentID != null) {
                if (this.partMap.containsKey(partContentID)) {
                    throw new MIMEException("Two MIME parts with the same Content-ID not allowed.");
                }
                this.partMap.put(partContentID, this.currentPart);
            }
            if (isRootPart) {
                this.rootPart = this.currentPart;
            }
            if (this.partCreationListener != null) {
                this.partCreationListener.partCreated(this.currentPart);
            }
        }
        return this.currentPart;
    }

    private static void checkParserState(EntityState state, EntityState expected) throws IllegalStateException {
        if (expected != state) {
            throw new IllegalStateException("Internal error: expected parser to be in state " + expected + ", but got " + state);
        }
    }

    @Override
    public Iterator<Part> iterator() {
        return new PartIterator(this);
    }

    public void detach() {
        while (this.getNextPart() != null) {
        }
    }

    public static final class Builder {
        private InputStream inputStream;
        private ContentType contentType;
        private WritableBlobFactory<?> attachmentBlobFactory;
        private DataHandlerFactory dataHandlerFactory;
        private PartCreationListener partCreationListener;

        Builder() {
        }

        public Builder setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder setContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setContentType(String contentType) {
            try {
                this.contentType = new ContentType(contentType);
            }
            catch (ParseException ex) {
                throw new MIMEException(ex);
            }
            return this;
        }

        public Builder setAttachmentBlobFactory(WritableBlobFactory<?> attachmentBlobFactory) {
            this.attachmentBlobFactory = attachmentBlobFactory;
            return this;
        }

        public Builder setDataHandlerFactory(DataHandlerFactory dataHandlerFactory) {
            this.dataHandlerFactory = dataHandlerFactory;
            return this;
        }

        public Builder setPartCreationListener(PartCreationListener partCreationListener) {
            this.partCreationListener = partCreationListener;
            return this;
        }

        public MultipartBody build() {
            if (this.inputStream == null) {
                throw new IllegalArgumentException("inputStream is mandatory");
            }
            if (this.contentType == null) {
                throw new IllegalArgumentException("contentType is mandatory");
            }
            return new MultipartBody(this.inputStream, this.contentType, this.attachmentBlobFactory == null ? MemoryBlob.FACTORY : this.attachmentBlobFactory, this.dataHandlerFactory == null ? DataHandlerFactory.DEFAULT : this.dataHandlerFactory, this.partCreationListener);
        }
    }

    public static interface PartCreationListener {
        public void partCreated(Part var1);
    }
}

