/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Priority;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardContextSelect;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterAsyncSupported;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterDispatcher;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterName;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterPattern;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterServlet;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardListener;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletAsyncSupported;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletMultipart;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletName;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletPattern;
import org.apache.aries.cdi.extra.propertytypes.ServiceDescription;
import org.apache.aries.cdi.extra.propertytypes.ServiceRanking;
import org.jboss.weld.module.web.servlet.WeldInitialListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cdi.annotations.Service;

public class HttpExtension
implements Extension {
    private static final String CONTEXT_PATH_PREFIX = "(osgi.http.whiteboard.context.path=";
    private static final String DEFAULT_CONTEXT_FILTER = "(osgi.http.whiteboard.context.name=default)";
    private static final String[] LISTENER_CLASSES = new String[]{ServletContextListener.class.getName(), ServletRequestListener.class.getName(), HttpSessionListener.class.getName()};
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final Bundle _bundle;
    private String _contextSelect;
    private volatile ServiceRegistration<?> _listenerRegistration;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public HttpExtension(Bundle bundle) {
        this._bundle = bundle;
    }

    <X> void processWebFilter(@Observes @WithAnnotations(value={WebFilter.class}) ProcessAnnotatedType<X> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        WebFilter webFilter = (WebFilter)annotatedType.getAnnotation(WebFilter.class);
        HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
        if (!annotatedType.isAnnotationPresent(Service.class)) {
            annotations.add((Annotation)Service.Literal.of((Class[])new Class[]{Filter.class}));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardContextSelect.class)) {
            annotations.add((Annotation)HttpWhiteboardContextSelect.Literal.of((String)this.getSelectedContext()));
        }
        if (!webFilter.description().isEmpty()) {
            annotations.add((Annotation)ServiceDescription.Literal.of((String)webFilter.description()));
        }
        if (!webFilter.filterName().isEmpty()) {
            annotations.add((Annotation)HttpWhiteboardFilterName.Literal.of((String)webFilter.filterName()));
        }
        if (webFilter.servletNames().length > 0) {
            annotations.add((Annotation)HttpWhiteboardFilterServlet.Literal.of((String[])webFilter.servletNames()));
        }
        if (webFilter.value().length > 0) {
            annotations.add((Annotation)HttpWhiteboardFilterPattern.Literal.of((String[])webFilter.value()));
        } else if (webFilter.urlPatterns().length > 0) {
            annotations.add((Annotation)HttpWhiteboardFilterPattern.Literal.of((String[])webFilter.urlPatterns()));
        }
        if (webFilter.dispatcherTypes().length > 0) {
            annotations.add((Annotation)HttpWhiteboardFilterDispatcher.Literal.of((DispatcherType[])webFilter.dispatcherTypes()));
        }
        annotations.add((Annotation)HttpWhiteboardFilterAsyncSupported.Literal.of((boolean)webFilter.asyncSupported()));
        pat.setAnnotatedType(new WebAnnotated(annotatedType, annotations));
    }

    <X> void processWebListener(@Observes @WithAnnotations(value={WebListener.class}) ProcessAnnotatedType<X> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        WebListener webListener = (WebListener)annotatedType.getAnnotation(WebListener.class);
        HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
        if (!annotatedType.isAnnotationPresent(Service.class)) {
            ArrayList<Class<HttpSessionIdListener>> listenerTypes = new ArrayList<Class<HttpSessionIdListener>>();
            Class javaClass = annotatedType.getJavaClass();
            if (ServletContextListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(ServletContextListener.class);
            }
            if (ServletContextAttributeListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(ServletContextAttributeListener.class);
            }
            if (ServletRequestListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(ServletRequestListener.class);
            }
            if (ServletRequestAttributeListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(ServletRequestAttributeListener.class);
            }
            if (HttpSessionListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(HttpSessionListener.class);
            }
            if (HttpSessionAttributeListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(HttpSessionAttributeListener.class);
            }
            if (HttpSessionIdListener.class.isAssignableFrom(javaClass)) {
                listenerTypes.add(HttpSessionIdListener.class);
            }
            annotations.add((Annotation)Service.Literal.of((Class[])listenerTypes.toArray(new Class[0])));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardContextSelect.class)) {
            annotations.add((Annotation)HttpWhiteboardContextSelect.Literal.of((String)this.getSelectedContext()));
        }
        annotations.add((Annotation)HttpWhiteboardListener.Literal.INSTANCE);
        if (!webListener.value().isEmpty()) {
            annotations.add((Annotation)ServiceDescription.Literal.of((String)webListener.value()));
        }
        pat.setAnnotatedType(new WebAnnotated(annotatedType, annotations));
    }

    <X> void processWebServlet(@Observes @WithAnnotations(value={WebServlet.class}) ProcessAnnotatedType<X> pat) {
        MultipartConfig multipartConfig;
        AnnotatedType annotatedType = pat.getAnnotatedType();
        WebServlet webServlet = (WebServlet)annotatedType.getAnnotation(WebServlet.class);
        HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
        if (!annotatedType.isAnnotationPresent(Service.class)) {
            annotations.add((Annotation)Service.Literal.of((Class[])new Class[]{Servlet.class}));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardContextSelect.class)) {
            annotations.add((Annotation)HttpWhiteboardContextSelect.Literal.of((String)this.getSelectedContext()));
        }
        if (!webServlet.name().isEmpty()) {
            annotations.add((Annotation)HttpWhiteboardServletName.Literal.of((String)webServlet.name()));
        }
        if (webServlet.value().length > 0) {
            annotations.add((Annotation)HttpWhiteboardServletPattern.Literal.of((String[])webServlet.value()));
        } else if (webServlet.urlPatterns().length > 0) {
            annotations.add((Annotation)HttpWhiteboardServletPattern.Literal.of((String[])webServlet.urlPatterns()));
        }
        annotations.add((Annotation)ServiceRanking.Literal.of((int)webServlet.loadOnStartup()));
        annotations.add((Annotation)HttpWhiteboardServletAsyncSupported.Literal.of((boolean)webServlet.asyncSupported()));
        if (!webServlet.description().isEmpty()) {
            annotations.add((Annotation)ServiceDescription.Literal.of((String)webServlet.description()));
        }
        if ((multipartConfig = (MultipartConfig)annotatedType.getAnnotation(MultipartConfig.class)) != null) {
            annotations.add((Annotation)HttpWhiteboardServletMultipart.Literal.of((boolean)true, (int)multipartConfig.fileSizeThreshold(), (String)multipartConfig.location(), (long)multipartConfig.maxFileSize(), (long)multipartConfig.maxRequestSize()));
        }
        pat.setAnnotatedType(new WebAnnotated(annotatedType, annotations));
    }

    void afterDeploymentValidation(@Observes @Priority(value=3800) AfterDeploymentValidation adv, BeanManager beanManager) {
        beanManager.getEvent().fireAsync((Object)new Ready());
    }

    void ready(@ObservesAsync Ready ready, BeanManager beanManager) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "Aries CDI - HTTP Portable Extension");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", this.getSelectedContext());
        ((Dictionary)properties).put("osgi.http.whiteboard.listener", Boolean.TRUE.toString());
        ((Dictionary)properties).put("service.ranking", 2147483547);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(WeldInitialListener.class);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        Bean bean = beanManager.createBean(beanManager.createBeanAttributes(annotatedType), WeldInitialListener.class, injectionTargetFactory);
        WeldInitialListener initialListener = (WeldInitialListener)bean.create(beanManager.createCreationalContext((Contextual)bean));
        this._listenerRegistration = this._bundle.getBundleContext().registerService(LISTENER_CLASSES, (Object)new ListenerWrapper(this, (HttpSessionListener)initialListener), properties);
    }

    void beforeShutdown(@Observes BeforeShutdown bs) {
        if (this._listenerRegistration != null && !this.destroyed.get()) {
            this._listenerRegistration.unregister();
        }
    }

    private Map<String, Object> getAttributes() {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        List wires = bundleWiring.getRequiredWires("osgi.extender");
        Map cdiAttributes = Collections.emptyMap();
        for (BundleWire wire : wires) {
            BundleCapability capability = wire.getCapability();
            Map attributes = capability.getAttributes();
            String extender = (String)attributes.get("osgi.extender");
            if (!extender.equals("osgi.cdi")) continue;
            BundleRequirement requirement = wire.getRequirement();
            cdiAttributes = requirement.getAttributes();
            break;
        }
        return cdiAttributes;
    }

    private String getSelectedContext() {
        if (this._contextSelect != null) {
            return this._contextSelect;
        }
        this._contextSelect = this.getSelectedContext0();
        return this._contextSelect;
    }

    private String getSelectedContext0() {
        Map<String, Object> attributes = this.getAttributes();
        if (attributes.containsKey("osgi.http.whiteboard.context.select")) {
            return (String)attributes.get("osgi.http.whiteboard.context.select");
        }
        Dictionary headers = this._bundle.getHeaders();
        if (headers.get(WEB_CONTEXT_PATH) != null) {
            return CONTEXT_PATH_PREFIX + (String)headers.get(WEB_CONTEXT_PATH) + ')';
        }
        return DEFAULT_CONTEXT_FILTER;
    }

    private class WebAnnotated<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> annotatedType;
        private final Set<Annotation> annotations;

        public WebAnnotated(AnnotatedType<X> annotatedType, Set<Annotation> annotations) {
            this.annotatedType = annotatedType;
            this.annotations = annotations;
        }

        public Type getBaseType() {
            return this.annotatedType.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.annotatedType.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)((Annotation)this.annotations.stream().filter(ann -> annotationType.isAssignableFrom(ann.annotationType())).map(ann -> (Annotation)annotationType.cast(ann)).findFirst().orElse(null));
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotations.stream().anyMatch(ann -> annotationType.isAssignableFrom(ann.annotationType()));
        }

        public Class<X> getJavaClass() {
            return this.annotatedType.getJavaClass();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.annotatedType.getConstructors();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.annotatedType.getMethods();
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.annotatedType.getFields();
        }
    }

    private static class ListenerWrapper<T extends HttpSessionListener & ServletContextListener>
    implements HttpSessionListener,
    ServletContextListener,
    ServletRequestListener {
        private final T delegate;
        final /* synthetic */ HttpExtension this$0;

        public ListenerWrapper(T delegate) {
            this.this$0 = var1_1;
            this.delegate = delegate;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            try {
                ((ServletContextListener)this.delegate).contextDestroyed(sce);
            }
            finally {
                this.this$0.destroyed.set(true);
            }
        }

        public void contextInitialized(ServletContextEvent sce) {
            ((ServletContextListener)this.delegate).contextInitialized(sce);
        }

        public void requestDestroyed(ServletRequestEvent sre) {
            ((ServletRequestListener)this.delegate).requestDestroyed(sre);
        }

        public void requestInitialized(ServletRequestEvent sre) {
            ((ServletRequestListener)this.delegate).requestInitialized(sre);
        }

        public void sessionCreated(HttpSessionEvent se) {
            this.delegate.sessionCreated(se);
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            this.delegate.sessionDestroyed(se);
        }
    }

    public static class Ready {
    }
}

