/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.shipping.engine.fixed.model.impl;

import com.liferay.commerce.shipping.engine.fixed.model.CommerceShippingFixedOptionQualifier;
import com.liferay.commerce.shipping.engine.fixed.service.CommerceShippingFixedOptionQualifierLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceShippingFixedOptionQualifier service. Represents a row in the &quot;CSFixedOptionQualifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShippingFixedOptionQualifierImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingFixedOptionQualifierImpl
 * @see CommerceShippingFixedOptionQualifier
 * @generated
 */
public abstract class CommerceShippingFixedOptionQualifierBaseImpl
	extends CommerceShippingFixedOptionQualifierModelImpl
	implements CommerceShippingFixedOptionQualifier {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipping fixed option qualifier model instance should use the <code>CommerceShippingFixedOptionQualifier</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceShippingFixedOptionQualifierLocalServiceUtil.
				addCommerceShippingFixedOptionQualifier(this);
		}
		else {
			CommerceShippingFixedOptionQualifierLocalServiceUtil.
				updateCommerceShippingFixedOptionQualifier(this);
		}
	}

}