/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.service.impl;

import com.liferay.commerce.pricing.exception.CommercePricingClassTitleException;
import com.liferay.commerce.pricing.exception.NoSuchPricingClassException;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRelModel;
import com.liferay.commerce.pricing.service.CommercePricingClassCPDefinitionRelLocalService;
import com.liferay.commerce.pricing.service.base.CommercePricingClassLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.pricing.model.CommercePricingClass"}, service={AopService.class})
public class CommercePricingClassLocalServiceImpl
extends CommercePricingClassLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"companyId", "entryClassName", "entryClassPK", "title"};
    private static final Log _log = LogFactoryUtil.getLog(CommercePricingClassLocalServiceImpl.class);
    @Reference
    private CommercePricingClassCPDefinitionRelLocalService _commercePricingClassCPDefinitionRelLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommercePricingClass addCommercePricingClass(long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        return this.addCommercePricingClass(null, userId, titleMap, descriptionMap, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePricingClass addCommercePricingClass(String externalReferenceCode, long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(titleMap);
        long commercePricingClassId = this.counterLocalService.increment();
        CommercePricingClass commercePricingClass = this.commercePricingClassPersistence.create(commercePricingClassId);
        commercePricingClass.setExternalReferenceCode(externalReferenceCode);
        commercePricingClass.setCompanyId(serviceContext.getCompanyId());
        commercePricingClass.setUserId(user.getUserId());
        commercePricingClass.setUserName(user.getFullName());
        commercePricingClass.setTitleMap(titleMap);
        commercePricingClass.setDescriptionMap(descriptionMap);
        Date date = new Date();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)date.getTime(), (TimeZone)user.getTimeZone());
        commercePricingClass.setLastPublishDate(calendar.getTime());
        commercePricingClass.setExpandoBridgeAttributes(serviceContext);
        commercePricingClass = (CommercePricingClass)this.commercePricingClassPersistence.update((BaseModel)commercePricingClass);
        this._resourceLocalService.addModelResources((AuditedModel)commercePricingClass, serviceContext);
        return commercePricingClass;
    }

    public CommercePricingClass addOrUpdateCommercePricingClass(String externalReferenceCode, long commercePricingClassId, long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        CommercePricingClass commercePricingClass;
        block4: {
            if (commercePricingClassId > 0L) {
                try {
                    return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClassId, userId, titleMap, descriptionMap, serviceContext);
                }
                catch (NoSuchPricingClassException noSuchPricingClassException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find pricing class with ID: " + commercePricingClassId), (Throwable)noSuchPricingClassException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commercePricingClass = this.commercePricingClassPersistence.fetchByERC_C(externalReferenceCode, serviceContext.getCompanyId())) != null) {
            return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClassId, userId, titleMap, descriptionMap, serviceContext);
        }
        return this.commercePricingClassLocalService.addCommercePricingClass(externalReferenceCode, userId, titleMap, descriptionMap, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommercePricingClass deleteCommercePricingClass(CommercePricingClass commercePricingClass) throws PortalException {
        long commercePricingClassId = commercePricingClass.getCommercePricingClassId();
        this._commercePricingClassCPDefinitionRelLocalService.deleteCommercePricingClassCPDefinitionRels(commercePricingClassId);
        this.commercePricingClassPersistence.remove((BaseModel)commercePricingClass);
        this._resourceLocalService.deleteResource((AuditedModel)commercePricingClass, 4);
        this._expandoRowLocalService.deleteRows(commercePricingClassId);
        return commercePricingClass;
    }

    @Override
    public CommercePricingClass deleteCommercePricingClass(long commercePricingClassId) throws PortalException {
        CommercePricingClass commercePricingClass = this.commercePricingClassPersistence.findByPrimaryKey(commercePricingClassId);
        return this.commercePricingClassLocalService.deleteCommercePricingClass(commercePricingClass);
    }

    public void deleteCommercePricingClasses(long companyId) throws PortalException {
        List commercePricingClasses = this.commercePricingClassPersistence.findByCompanyId(companyId);
        for (CommercePricingClass commercePricingClass : commercePricingClasses) {
            this.commercePricingClassLocalService.deleteCommercePricingClass(commercePricingClass);
        }
    }

    public long[] getCommercePricingClassByCPDefinition(long cpDefinitionId) {
        return TransformUtil.transformToLongArray((Collection)this._commercePricingClassCPDefinitionRelLocalService.getCommercePricingClassByCPDefinitionId(cpDefinitionId), CommercePricingClassCPDefinitionRelModel::getCommercePricingClassId);
    }

    public int getCommercePricingClassCountByCPDefinitionId(long cpDefinitionId, String title) {
        return this.commercePricingClassFinder.countByCPDefinitionId(cpDefinitionId, title);
    }

    public List<CommercePricingClass> getCommercePricingClasses(long companyId, int start, int end, OrderByComparator<CommercePricingClass> orderByComparator) {
        return this.commercePricingClassPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCommercePricingClassesCount(long companyId) {
        return this.commercePricingClassPersistence.countByCompanyId(companyId);
    }

    public int getCommercePricingClassesCount(long cpDefinitionId, String title) {
        return this.commercePricingClassFinder.countByCPDefinitionId(cpDefinitionId, title);
    }

    public List<CommercePricingClass> searchByCPDefinitionId(long cpDefinitionId, String title, int start, int end) {
        return this.commercePricingClassFinder.findByCPDefinitionId(cpDefinitionId, title, start, end);
    }

    public BaseModelSearchResult<CommercePricingClass> searchCommercePricingClasses(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, start, end, sort);
        return this._searchCommercePricingClasses(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePricingClass updateCommercePricingClass(long commercePricingClassId, long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommercePricingClass commercePricingClass = this.commercePricingClassPersistence.findByPrimaryKey(commercePricingClassId);
        this._validate(titleMap);
        commercePricingClass.setCompanyId(serviceContext.getCompanyId());
        commercePricingClass.setUserId(user.getUserId());
        commercePricingClass.setUserName(user.getFullName());
        commercePricingClass.setTitleMap(titleMap);
        commercePricingClass.setDescriptionMap(descriptionMap);
        Date date = new Date();
        Calendar calendar = CalendarFactoryUtil.getCalendar((long)date.getTime(), (TimeZone)user.getTimeZone());
        commercePricingClass.setLastPublishDate(calendar.getTime());
        commercePricingClass.setExpandoBridgeAttributes(serviceContext);
        return (CommercePricingClass)this.commercePricingClassPersistence.update((BaseModel)commercePricingClass);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommercePricingClass updateCommercePricingClassExternalReferenceCode(String externalReferenceCode, long commercePricingClassId) throws PortalException {
        CommercePricingClass commercePricingClass = this.commercePricingClassLocalService.getCommercePricingClass(commercePricingClassId);
        commercePricingClass.setExternalReferenceCode(externalReferenceCode);
        return this.commercePricingClassLocalService.updateCommercePricingClass(commercePricingClass);
    }

    private SearchContext _buildSearchContext(long companyId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"content", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private List<CommercePricingClass> _getCommercePricingClasses(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommercePricingClass> commercePricingClasses = new ArrayList<CommercePricingClass>(documents.size());
        for (Document document : documents) {
            long commercePricingClassId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommercePricingClass commercePricingClass = this.fetchCommercePricingClass(commercePricingClassId);
            if (commercePricingClass == null) {
                commercePricingClasses = null;
                Indexer indexer = this._indexerRegistry.getIndexer(CommercePricingClass.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commercePricingClasses == null) continue;
            commercePricingClasses.add(commercePricingClass);
        }
        return commercePricingClasses;
    }

    private BaseModelSearchResult<CommercePricingClass> _searchCommercePricingClasses(SearchContext searchContext) throws PortalException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(CommercePricingClass.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommercePricingClass> commercePricingClasses = this._getCommercePricingClasses(hits);
            if (commercePricingClasses == null) continue;
            return new BaseModelSearchResult(commercePricingClasses, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    private void _validate(Map<Locale, String> titleMap) throws PortalException {
        if (titleMap == null || titleMap.isEmpty()) {
            throw new CommercePricingClassTitleException();
        }
    }
}

