/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.modifier;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.pricing.model.CommercePriceModifier;
import com.liferay.commerce.pricing.modifier.CommercePriceModifierHelper;
import com.liferay.commerce.pricing.service.CommercePriceModifierLocalService;
import com.liferay.commerce.pricing.type.CommercePriceModifierType;
import com.liferay.commerce.pricing.type.CommercePriceModifierTypeRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommercePriceModifierHelper.class})
public class CommercePriceModifierHelperImpl
implements CommercePriceModifierHelper {
    private static final int _SCALE = 10;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommercePriceModifierLocalService _commercePriceModifierLocalService;
    @Reference
    private CommercePriceModifierTypeRegistry _commercePriceModifierTypeRegistry;

    public BigDecimal applyCommercePriceModifier(long commercePriceListId, long cpDefinitionId, CommerceMoney originalCommerceMoney) throws PortalException {
        List commercePriceModifiers = this._commercePriceModifierLocalService.getQualifiedCommercePriceModifiers(commercePriceListId, cpDefinitionId);
        BigDecimal lowestPrice = null;
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCommercePriceList(commercePriceListId);
        CommerceCurrency priceListCurrency = commercePriceList.getCommerceCurrency();
        CommerceCurrency originalCommerceCurrency = originalCommerceMoney.getCommerceCurrency();
        BigDecimal originalPrice = originalCommerceMoney.getPrice();
        if (!StringUtil.equals((String)commercePriceList.getCommerceCurrencyCode(), (String)originalCommerceCurrency.getCode())) {
            originalPrice = this._getPrice(originalPrice, priceListCurrency, originalCommerceCurrency);
        }
        String priceModifierKey = "";
        if (commercePriceModifiers != null && !commercePriceModifiers.isEmpty()) {
            for (CommercePriceModifier commercePriceModifier : commercePriceModifiers) {
                CommercePriceModifierType commercePriceModifierType = this._commercePriceModifierTypeRegistry.getCommercePriceModifierType(commercePriceModifier.getModifierType());
                BigDecimal actualPrice = commercePriceModifierType.evaluate(originalPrice, commercePriceModifier);
                if ("replace".equals(commercePriceModifierType.getKey()) && !StringUtil.equals((String)commercePriceList.getCommerceCurrencyCode(), (String)originalCommerceCurrency.getCode())) {
                    actualPrice = this._getPrice(actualPrice, priceListCurrency, originalCommerceCurrency);
                }
                if (lowestPrice != null && actualPrice.compareTo(lowestPrice) >= 0) continue;
                lowestPrice = actualPrice;
                priceModifierKey = commercePriceModifierType.getKey();
            }
        }
        if (lowestPrice == null) {
            return originalCommerceMoney.getPrice();
        }
        if (!"replace".equals(priceModifierKey) && !StringUtil.equals((String)commercePriceList.getCommerceCurrencyCode(), (String)originalCommerceCurrency.getCode())) {
            lowestPrice = this._getPrice(lowestPrice, originalCommerceCurrency, priceListCurrency);
        }
        RoundingMode roundingMode = RoundingMode.valueOf(originalCommerceCurrency.getRoundingMode());
        return lowestPrice.setScale(10, roundingMode);
    }

    public boolean hasCommercePriceModifiers(long commercePriceListId, long cpDefinitionId) throws PortalException {
        List commercePriceModifiers = this._commercePriceModifierLocalService.getQualifiedCommercePriceModifiers(commercePriceListId, cpDefinitionId);
        return !commercePriceModifiers.isEmpty();
    }

    private BigDecimal _getPrice(BigDecimal price, CommerceCurrency commerceCurrency1, CommerceCurrency commerceCurrency2) {
        price = price.divide(commerceCurrency1.getRate(), RoundingMode.valueOf(commerceCurrency1.getRoundingMode()));
        price = price.multiply(commerceCurrency2.getRate());
        return price;
    }
}

