/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.service.impl;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.commerce.payment.exception.DuplicateCommercePaymentMethodGroupRelQualifierException;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRelQualifier;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRelQualifierTable;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRelTable;
import com.liferay.commerce.payment.service.base.CommercePaymentMethodGroupRelQualifierLocalServiceBaseImpl;
import com.liferay.commerce.term.model.CommerceTermEntry;
import com.liferay.commerce.term.model.CommerceTermEntryTable;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.payment.model.CommercePaymentMethodGroupRelQualifier"}, service={AopService.class})
public class CommercePaymentMethodGroupRelQualifierLocalServiceImpl
extends CommercePaymentMethodGroupRelQualifierLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public CommercePaymentMethodGroupRelQualifier addCommercePaymentMethodGroupRelQualifier(long userId, String className, long classPK, long commercePaymentMethodGroupRelId) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this._validate(classNameId, classPK, commercePaymentMethodGroupRelId);
        CommercePaymentMethodGroupRelQualifier commercePaymentMethodGroupRelQualifier = this.commercePaymentMethodGroupRelQualifierPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        commercePaymentMethodGroupRelQualifier.setCompanyId(user.getCompanyId());
        commercePaymentMethodGroupRelQualifier.setUserId(user.getUserId());
        commercePaymentMethodGroupRelQualifier.setUserName(user.getFullName());
        commercePaymentMethodGroupRelQualifier.setClassNameId(classNameId);
        commercePaymentMethodGroupRelQualifier.setClassPK(classPK);
        commercePaymentMethodGroupRelQualifier.setCommercePaymentMethodGroupRelId(commercePaymentMethodGroupRelId);
        return (CommercePaymentMethodGroupRelQualifier)this.commercePaymentMethodGroupRelQualifierPersistence.update((BaseModel)commercePaymentMethodGroupRelQualifier);
    }

    @Override
    @SystemEvent(type=1)
    public CommercePaymentMethodGroupRelQualifier deleteCommercePaymentMethodGroupRelQualifier(CommercePaymentMethodGroupRelQualifier commercePaymentMethodGroupRelQualifier) throws PortalException {
        this.commercePaymentMethodGroupRelQualifierPersistence.remove((BaseModel)commercePaymentMethodGroupRelQualifier);
        return commercePaymentMethodGroupRelQualifier;
    }

    @Override
    public CommercePaymentMethodGroupRelQualifier deleteCommercePaymentMethodGroupRelQualifier(long commercePaymentMethodGroupRelQualifierId) throws PortalException {
        CommercePaymentMethodGroupRelQualifier commercePaymentMethodGroupRelQualifier = this.commercePaymentMethodGroupRelQualifierPersistence.findByPrimaryKey(commercePaymentMethodGroupRelQualifierId);
        return this.commercePaymentMethodGroupRelQualifierLocalService.deleteCommercePaymentMethodGroupRelQualifier(commercePaymentMethodGroupRelQualifier);
    }

    public void deleteCommercePaymentMethodGroupRelQualifiers(long commercePaymentMethodGroupRelId) throws PortalException {
        List commercePaymentMethodGroupRelQualifiers = this.commercePaymentMethodGroupRelQualifierPersistence.findByCommercePaymentMethodGroupRelId(commercePaymentMethodGroupRelId);
        for (CommercePaymentMethodGroupRelQualifier commercePaymentMethodGroupRelQualifier : commercePaymentMethodGroupRelQualifiers) {
            this.commercePaymentMethodGroupRelQualifierLocalService.deleteCommercePaymentMethodGroupRelQualifier(commercePaymentMethodGroupRelQualifier);
        }
    }

    public void deleteCommercePaymentMethodGroupRelQualifiers(String className, long commercePaymentMethodGroupRelId) throws PortalException {
        List commercePaymentMethodGroupRelQualifiers = this.commercePaymentMethodGroupRelQualifierPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), commercePaymentMethodGroupRelId);
        for (CommercePaymentMethodGroupRelQualifier commercePaymentMethodGroupRelQualifier : commercePaymentMethodGroupRelQualifiers) {
            this.commercePaymentMethodGroupRelQualifierLocalService.deleteCommercePaymentMethodGroupRelQualifier(commercePaymentMethodGroupRelQualifier);
        }
    }

    public CommercePaymentMethodGroupRelQualifier fetchCommercePaymentMethodGroupRelQualifier(String className, long classPK, long commercePaymentMethodGroupRelId) {
        return this.commercePaymentMethodGroupRelQualifierPersistence.fetchByC_C_C(this._classNameLocalService.getClassNameId(className), classPK, commercePaymentMethodGroupRelId);
    }

    public List<CommercePaymentMethodGroupRelQualifier> getCommerceOrderTypeCommercePaymentMethodGroupRelQualifiers(long commercePaymentMethodGroupRelId, String keywords, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePaymentMethodGroupRelQualifierTable.INSTANCE), (Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classPK), commercePaymentMethodGroupRelId, CommerceOrderType.class.getName(), keywords, (Expression<String>)CommerceOrderTypeTable.INSTANCE.name).limit(start, end));
    }

    public int getCommerceOrderTypeCommercePaymentMethodGroupRelQualifiersCount(long commercePaymentMethodGroupRelId, String keywords) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.commercePaymentMethodGroupRelQualifierId), (Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classPK), commercePaymentMethodGroupRelId, CommerceOrderType.class.getName(), keywords, (Expression<String>)CommerceOrderTypeTable.INSTANCE.name));
    }

    public List<CommercePaymentMethodGroupRelQualifier> getCommercePaymentMethodGroupRelQualifiers(long commercePaymentMethodGroupRelId, int start, int end, OrderByComparator<CommercePaymentMethodGroupRelQualifier> orderByComparator) {
        return this.commercePaymentMethodGroupRelQualifierPersistence.findByCommercePaymentMethodGroupRelId(commercePaymentMethodGroupRelId, start, end, orderByComparator);
    }

    public List<CommercePaymentMethodGroupRelQualifier> getCommercePaymentMethodGroupRelQualifiers(String className, long commercePaymentMethodGroupRelId) {
        return this.commercePaymentMethodGroupRelQualifierPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), commercePaymentMethodGroupRelId);
    }

    public int getCommercePaymentMethodGroupRelQualifiersCount(long commercePaymentMethodGroupRelId) {
        return this.commercePaymentMethodGroupRelQualifierPersistence.countByCommercePaymentMethodGroupRelId(commercePaymentMethodGroupRelId);
    }

    public List<CommercePaymentMethodGroupRelQualifier> getCommerceTermEntryCommercePaymentMethodGroupRelQualifiers(long commercePaymentMethodGroupRelId, String keywords, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommercePaymentMethodGroupRelQualifierTable.INSTANCE), (Table)CommerceTermEntryTable.INSTANCE, CommerceTermEntryTable.INSTANCE.commerceTermEntryId.eq((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classPK), commercePaymentMethodGroupRelId, CommerceTermEntry.class.getName(), keywords, (Expression<String>)CommerceTermEntryTable.INSTANCE.name).limit(start, end));
    }

    public int getCommerceTermEntryCommercePaymentMethodGroupRelQualifiersCount(long commercePaymentMethodGroupRelId, String keywords) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.commercePaymentMethodGroupRelQualifierId), (Table)CommerceTermEntryTable.INSTANCE, CommerceTermEntryTable.INSTANCE.commerceTermEntryId.eq((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classPK), commercePaymentMethodGroupRelId, CommerceTermEntry.class.getName(), keywords, (Expression<String>)CommerceTermEntryTable.INSTANCE.name));
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Table innerJoinTable, Predicate innerJoinPredicate, Long commercePaymentMethodGroupRelId, String className, String keywords, Expression<String> keywordsPredicateExpression) {
        JoinStep joinStep = fromStep.from((Table)CommercePaymentMethodGroupRelQualifierTable.INSTANCE).innerJoinON((Table)CommercePaymentMethodGroupRelTable.INSTANCE, CommercePaymentMethodGroupRelTable.INSTANCE.commercePaymentMethodGroupRelId.eq((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.commercePaymentMethodGroupRelId)).innerJoinON(innerJoinTable, innerJoinPredicate);
        return joinStep.where(() -> CommercePaymentMethodGroupRelQualifierTable.INSTANCE.commercePaymentMethodGroupRelId.eq((Object)commercePaymentMethodGroupRelId).and((Expression)CommercePaymentMethodGroupRelQualifierTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className))).and(() -> {
            if (Validator.isNull((String)keywords)) {
                return null;
            }
            return Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)keywordsPredicateExpression), this._customSQL.keywords(keywords, true)));
        }));
    }

    private void _validate(long classNameId, long classPK, long commercePaymentMethodGroupRelId) throws PortalException {
        CommercePaymentMethodGroupRelQualifier commercePaymentMethodGroupRelQualifier = this.commercePaymentMethodGroupRelQualifierPersistence.fetchByC_C_C(classNameId, classPK, commercePaymentMethodGroupRelId);
        if (commercePaymentMethodGroupRelQualifier != null) {
            throw new DuplicateCommercePaymentMethodGroupRelQualifierException();
        }
    }
}

