/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.util;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.payment.integration.CommercePaymentIntegration;
import com.liferay.commerce.payment.integration.CommercePaymentIntegrationRegistry;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.request.CommercePaymentRequestProvider;
import com.liferay.commerce.payment.request.CommercePaymentRequestProviderRegistry;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.payment.util.CommercePaymentHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.security.Key;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommercePaymentHelper.class})
public class CommercePaymentHelperImpl
implements CommercePaymentHelper {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommercePaymentIntegrationRegistry _commercePaymentIntegrationRegistry;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommercePaymentRequestProviderRegistry _commercePaymentRequestProviderRegistry;
    @Reference
    private Encryptor _encryptor;
    @Reference
    private Portal _portal;

    public CommercePaymentResult emptyResult(long commerceOrderId, String transactionId) {
        return new CommercePaymentResult(transactionId, commerceOrderId, -1, false, null, null, Collections.emptyList(), false);
    }

    public CommercePaymentIntegration getCommercePaymentIntegration(long commerceChannelId, String paymentIntegrationKey) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commerceChannel.getGroupId(), paymentIntegrationKey);
        if (commercePaymentMethodGroupRel == null || !commercePaymentMethodGroupRel.isActive()) {
            return null;
        }
        return this._commercePaymentIntegrationRegistry.getCommercePaymentIntegration(commercePaymentMethodGroupRel.getPaymentIntegrationKey());
    }

    public CommercePaymentMethod getCommercePaymentMethod(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (commercePaymentMethodKey.isEmpty()) {
            return null;
        }
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commercePaymentMethodKey);
        if (commercePaymentMethodGroupRel == null || !commercePaymentMethodGroupRel.isActive()) {
            return null;
        }
        return this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getPaymentIntegrationKey());
    }

    public CommercePaymentRequest getCommercePaymentRequest(CommerceOrder commerceOrder, Locale locale, String transactionId, String checkoutStepUrl, HttpServletRequest httpServletRequest, CommercePaymentMethod commercePaymentMethod) throws Exception {
        String cancelUrl = null;
        String returnUrl = null;
        if (1 == commercePaymentMethod.getPaymentType()) {
            cancelUrl = this._getCancelUrl(httpServletRequest, commerceOrder, checkoutStepUrl, commercePaymentMethod);
            returnUrl = this._getReturnUrl(httpServletRequest, commerceOrder, checkoutStepUrl, commercePaymentMethod);
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this.getCommercePaymentRequestProvider(commercePaymentMethod);
        return commercePaymentRequestProvider.getCommercePaymentRequest(cancelUrl, commerceOrder.getCommerceOrderId(), httpServletRequest, locale, returnUrl, transactionId);
    }

    public CommercePaymentRequestProvider getCommercePaymentRequestProvider(CommercePaymentMethod commercePaymentMethod) {
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentRequestProviderRegistry.getCommercePaymentRequestProvider(commercePaymentMethod.getKey());
        if (commercePaymentRequestProvider == null) {
            commercePaymentRequestProvider = this._commercePaymentRequestProviderRegistry.getCommercePaymentRequestProvider("default");
        }
        return commercePaymentRequestProvider;
    }

    public boolean isDeliveryOnlySubscription(CommerceOrder commerceOrder) {
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            if (!Validator.isNotNull((String)commerceOrderItem.getSubscriptionType())) continue;
            return false;
        }
        return true;
    }

    private StringBundler _getBaseUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod, int extraCapacity) throws Exception {
        StringBundler sb = new StringBundler(extraCapacity + (Validator.isNotNull((String)redirect) ? 12 : 10));
        sb.append(this._portal.getPortalURL(httpServletRequest));
        sb.append(this._portal.getPathModule());
        sb.append('/');
        sb.append(commercePaymentMethod.getServletPath());
        sb.append("?groupId=");
        sb.append(commerceOrder.getGroupId());
        sb.append("&uuid=");
        sb.append(URLCodec.encodeURL((String)commerceOrder.getUuid()));
        if (commerceOrder.isGuestOrder()) {
            Company company = this._portal.getCompany(httpServletRequest);
            Key key = company.getKeyObj();
            String token = this._encryptor.encrypt(key, String.valueOf(commerceOrder.getCommerceOrderId()));
            sb.append("&guestToken=");
            sb.append(token);
            sb.append("&");
        }
        if (Validator.isNotNull((String)redirect)) {
            sb.append("&redirect=");
            sb.append(URLCodec.encodeURL((String)redirect));
        }
        return sb;
    }

    private String _getCancelUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod) throws Exception {
        StringBundler sb = this._getBaseUrl(httpServletRequest, commerceOrder, redirect, commercePaymentMethod, 1);
        sb.append("&cancel=true");
        return sb.toString();
    }

    private String _getReturnUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod) throws Exception {
        StringBundler sb = this._getBaseUrl(httpServletRequest, commerceOrder, redirect, commercePaymentMethod, 0);
        if (commerceOrder.isSubscriptionOrder() && !this.isDeliveryOnlySubscription(commerceOrder)) {
            sb.append("&orderType=subscription");
        } else {
            sb.append("&orderType=normal");
        }
        return sb.toString();
    }
}

