/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.upgrade.v1_3_0;

import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;

public class CommercePaymentMethodGroupRelUpgradeProcess
extends UpgradeProcess {
    private static final String[] _OWNER_PERMISSIONS = new String[]{"DELETE", "PERMISSIONS", "UPDATE", "VIEW"};
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourceLocalService _resourceLocalService;

    public CommercePaymentMethodGroupRelUpgradeProcess(ResourceActionLocalService resourceActionLocalService, ResourceLocalService resourceLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    public void doUpgrade() throws Exception {
        this._resourceActionLocalService.checkResourceActions(CommercePaymentMethodGroupRel.class.getName(), Arrays.asList(_OWNER_PERMISSIONS), true);
        String selectCommercePaymentMethodGroupRelSQL = "select CPaymentMethodGroupRelId, companyId, groupId, userId from CommercePaymentMethodGroupRel";
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(selectCommercePaymentMethodGroupRelSQL);){
            while (resultSet.next()) {
                long commercePaymentMethodGroupRelId = resultSet.getLong("CPaymentMethodGroupRelId");
                long companyId = resultSet.getLong("companyId");
                long groupId = resultSet.getLong("groupId");
                long userId = resultSet.getLong("userId");
                ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])new String[0], (String[])new String[0]);
                modelPermissions.addRolePermissions("Owner", _OWNER_PERMISSIONS);
                modelPermissions.addRolePermissions("Guest", new String[]{"VIEW"});
                modelPermissions.addRolePermissions("User", new String[]{"VIEW"});
                this._resourceLocalService.addModelResources(companyId, groupId, userId, CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRelId, modelPermissions);
            }
        }
    }
}

