/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.upgrade.v1_0_1;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommercePaymentMethodGroupRelUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;

    public CommercePaymentMethodGroupRelUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select CPaymentMethodGroupRelId, groupId from CommercePaymentMethodGroupRel");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update CommercePaymentMethodGroupRel set groupId = ? where CPaymentMethodGroupRelId = ?");){
            while (resultSet.next()) {
                long commerceChannelGroupId = this._getCommerceChannelGroupIdBySiteGroupId(resultSet.getLong("groupId"));
                if (commerceChannelGroupId == 0L) continue;
                preparedStatement.setLong(1, commerceChannelGroupId);
                preparedStatement.setLong(2, resultSet.getLong("CPaymentMethodGroupRelId"));
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    private long _getCommerceChannelGroupIdBySiteGroupId(long groupId) throws SQLException {
        long companyId = 0L;
        long commerceChannelId = 0L;
        String sql = "select * from CommerceChannel where siteGroupId = " + groupId;
        try (Statement s = this.connection.createStatement();){
            s.setMaxRows(1);
            try (ResultSet resultSet = s.executeQuery(sql);){
                if (resultSet.next()) {
                    companyId = resultSet.getLong("companyId");
                    commerceChannelId = resultSet.getLong("commerceChannelId");
                }
            }
        }
        Group group = this._groupLocalService.fetchGroup(companyId, this._classNameLocalService.getClassNameId(CommerceChannel.class.getName()), commerceChannelId);
        if (group != null) {
            return group.getGroupId();
        }
        return 0L;
    }
}

