/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.commerce.payment.model.CommercePaymentEntry"}, service={ModelPreFilterContributor.class})
public class CommercePaymentEntryModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByClassNameIds(booleanFilter, searchContext);
        this._filterByClassPKs(booleanFilter, searchContext);
        this._filterByCurrencyCodes(booleanFilter, searchContext);
        this._filterByPaymentMethodNames(booleanFilter, searchContext);
        this._filterByStatuses(booleanFilter, searchContext);
        this._filterByType(booleanFilter, searchContext);
    }

    private void _filterByClassNameIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] classNameIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("classNameIds"), null);
        if (classNameIds == null) {
            return;
        }
        BooleanFilter classNameIdsBooleanFilter = new BooleanFilter();
        for (long classNameId : classNameIds) {
            classNameIdsBooleanFilter.add((Filter)new TermFilter("classNameId", String.valueOf(classNameId)), BooleanClauseOccur.SHOULD);
        }
        classNameIdsBooleanFilter.add((Filter)new MissingFilter("classNameId"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)classNameIdsBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByClassPKs(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] classPKs = GetterUtil.getLongValues((Object)searchContext.getAttribute("classPKs"), null);
        if (classPKs == null) {
            return;
        }
        BooleanFilter classPKsBooleanFilter = new BooleanFilter();
        for (long classPK : classPKs) {
            classPKsBooleanFilter.add((Filter)new TermFilter("classPK", String.valueOf(classPK)), BooleanClauseOccur.SHOULD);
        }
        classPKsBooleanFilter.add((Filter)new MissingFilter("classPK"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)classPKsBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByCurrencyCodes(BooleanFilter booleanFilter, SearchContext searchContext) {
        String[] currencyCodes = GetterUtil.getStringValues((Object)searchContext.getAttribute("currencyCodes"));
        if (currencyCodes.length < 1) {
            return;
        }
        BooleanFilter currencyCodesBooleanFilter = new BooleanFilter();
        for (String currencyCode : currencyCodes) {
            currencyCodesBooleanFilter.add((Filter)new TermFilter("currencyCode", String.valueOf(currencyCode)), BooleanClauseOccur.SHOULD);
        }
        currencyCodesBooleanFilter.add((Filter)new MissingFilter("currencyCode"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)currencyCodesBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByPaymentMethodNames(BooleanFilter booleanFilter, SearchContext searchContext) {
        String[] paymentMethodNames = GetterUtil.getStringValues((Object)searchContext.getAttribute("paymentMethodNames"));
        if (paymentMethodNames.length < 1) {
            return;
        }
        BooleanFilter paymentMethodNamesBooleanFilter = new BooleanFilter();
        for (String paymentMethodName : paymentMethodNames) {
            paymentMethodNamesBooleanFilter.add((Filter)new TermFilter("paymentMethodName", String.valueOf(paymentMethodName)), BooleanClauseOccur.SHOULD);
        }
        paymentMethodNamesBooleanFilter.add((Filter)new MissingFilter("paymentMethodName"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)paymentMethodNamesBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByStatuses(BooleanFilter booleanFilter, SearchContext searchContext) {
        int[] paymentStatuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("paymentStatuses"), null);
        if (paymentStatuses == null) {
            return;
        }
        BooleanFilter statusesBooleanFilter = new BooleanFilter();
        int[] nArray = paymentStatuses;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long paymentStatus = nArray[i];
            statusesBooleanFilter.add((Filter)new TermFilter("paymentStatus", String.valueOf(paymentStatus)), BooleanClauseOccur.SHOULD);
        }
        statusesBooleanFilter.add((Filter)new MissingFilter("paymentStatus"), BooleanClauseOccur.SHOULD);
        if (GetterUtil.getBoolean((Object)searchContext.getAttribute("excludePaymentStatuses"))) {
            booleanFilter.add((Filter)statusesBooleanFilter, BooleanClauseOccur.MUST_NOT);
        } else {
            booleanFilter.add((Filter)statusesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _filterByType(BooleanFilter booleanFilter, SearchContext searchContext) {
        Integer type = (Integer)searchContext.getAttribute("type");
        if (type != null) {
            booleanFilter.addRequiredTerm("type", type);
        }
    }
}

