/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.search.spi.model.index.contributor;

import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.payment.model.CommercePaymentEntry"}, service={ModelDocumentContributor.class})
public class CommercePaymentEntryModelDocumentContributor
implements ModelDocumentContributor<CommercePaymentEntry> {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentEntryModelDocumentContributor.class);
    @Reference
    private Localization _localization;

    public void contribute(Document document, CommercePaymentEntry commercePaymentEntry) {
        block3: {
            try {
                String[] languageIds;
                document.addNumberSortable("entryClassPK", Long.valueOf(commercePaymentEntry.getCommercePaymentEntryId()));
                document.addNumber("classNameId", commercePaymentEntry.getClassNameId());
                document.addNumber("classPK", commercePaymentEntry.getClassPK());
                document.addKeyword("currencyCode", commercePaymentEntry.getCurrencyCode());
                document.addKeyword("externalReferenceCode", commercePaymentEntry.getExternalReferenceCode());
                document.addText("note", commercePaymentEntry.getNote());
                document.addKeyword("paymentIntegrationKey", commercePaymentEntry.getPaymentIntegrationKey());
                document.addKeyword("paymentStatus", commercePaymentEntry.getPaymentStatus());
                document.addKeyword("reasonKey", commercePaymentEntry.getReasonKey());
                for (String languageId : languageIds = this._getLanguageIds(commercePaymentEntry.getDefaultLanguageId(), commercePaymentEntry.getReasonName())) {
                    document.addText(this._localization.getLocalizedName("reasonName", languageId), commercePaymentEntry.getReasonName(languageId));
                }
                document.addKeyword("transactionCode", commercePaymentEntry.getTransactionCode());
                document.addNumber("type", commercePaymentEntry.getType());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to commerce index payment entry " + commercePaymentEntry.getCommercePaymentEntryId()), (Throwable)exception);
            }
        }
    }

    private String[] _getLanguageIds(String defaultLanguageId, String value) {
        String[] languageIds = this._localization.getAvailableLanguageIds(value);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

