/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.model.listener;

import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CommercePaymentEntryModelListener
extends BaseModelListener<CommercePaymentEntry> {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentEntryModelListener.class);
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void onAfterUpdate(CommercePaymentEntry originalCommercePaymentEntry, CommercePaymentEntry commercePaymentEntry) throws ModelListenerException {
        block6: {
            try {
                if (StringUtil.equals((String)commercePaymentEntry.getClassName(), (String)CommerceOrder.class.getName()) && originalCommercePaymentEntry.getPaymentStatus() != commercePaymentEntry.getPaymentStatus()) {
                    CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commercePaymentEntry.getClassPK());
                    CommerceGroupThreadLocal.set((Group)this._groupLocalService.fetchGroup(commerceOrder.getGroupId()));
                    long commerceOrderId = commerceOrder.getCommerceOrderId();
                    int paymentStatus = commercePaymentEntry.getPaymentStatus();
                    if (commercePaymentEntry.getPaymentStatus() != 18) {
                        commerceOrder = this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, paymentStatus, commercePaymentEntry.getTransactionCode());
                        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, paymentStatus, commercePaymentEntry.getErrorMessages());
                    }
                    if (paymentStatus == 0 && commerceOrder.getOrderStatus() != 1) {
                        long userId = commerceOrder.getUserId();
                        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                        if (permissionChecker != null) {
                            userId = permissionChecker.getUserId();
                        }
                        this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 1, userId, true);
                    }
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Throwable)portalException);
            }
        }
    }
}

