/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.method;

import com.liferay.commerce.payment.internal.configuration.OfflineCommercePaymentMethodConfiguration;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.payment.internal.configuration.OfflineCommercePaymentMethodConfiguration"}, service={CommercePaymentMethod.class})
public class OfflineCommercePaymentMethod
implements CommercePaymentMethod {
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private Language _language;
    private volatile OfflineCommercePaymentMethodConfiguration _offlineCommercePaymentMethodConfiguration;

    public CommercePaymentResult completePayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        return new CommercePaymentResult(commercePaymentRequest.getTransactionId(), commercePaymentRequest.getCommerceOrderId(), 1, false, null, null, Collections.emptyList(), true);
    }

    public String getDescription(Locale locale) {
        return null;
    }

    public String getKey() {
        return this._offlineCommercePaymentMethodConfiguration.key();
    }

    public String getName(Locale locale) {
        return this._language.get(this._getResourceBundle(locale), this._offlineCommercePaymentMethodConfiguration.key());
    }

    public int getPaymentType() {
        return 2;
    }

    public String getServletPath() {
        return null;
    }

    public boolean isCompleteEnabled() {
        return true;
    }

    public boolean isProcessPaymentEnabled() {
        return true;
    }

    public CommercePaymentResult processPayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        return new CommercePaymentResult(commercePaymentRequest.getTransactionId(), commercePaymentRequest.getCommerceOrderId(), 2, false, null, null, Collections.emptyList(), true);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._offlineCommercePaymentMethodConfiguration = (OfflineCommercePaymentMethodConfiguration)ConfigurableUtil.createConfigurable(OfflineCommercePaymentMethodConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        String key = this.getKey();
        if (key == null) {
            return;
        }
        List commercePaymentMethodGroupRels = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(-1, -1);
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            if (!key.equals(commercePaymentMethodGroupRel.getPaymentIntegrationKey())) continue;
            this._commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws PortalException {
        this._offlineCommercePaymentMethodConfiguration = (OfflineCommercePaymentMethodConfiguration)ConfigurableUtil.createConfigurable(OfflineCommercePaymentMethodConfiguration.class, properties);
        List commercePaymentMethodGroupRels = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(-1, -1);
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            String key = (String)properties.get("key");
            if (!key.equals(commercePaymentMethodGroupRel.getPaymentIntegrationKey())) continue;
            this._commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
        }
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }
}

