/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.integration;

import com.liferay.commerce.payment.integration.CommercePaymentIntegration;
import com.liferay.commerce.payment.internal.configuration.FunctionCommercePaymentIntegrationConfiguration;
import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.catapult.PortalCatapult;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.payment.internal.configuration.FunctionCommercePaymentIntegrationConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={CommercePaymentIntegration.class})
public class FunctionCommercePaymentIntegration
implements CommercePaymentIntegration {
    private static final Log _log = LogFactoryUtil.getLog(FunctionCommercePaymentIntegration.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    private volatile FunctionCommercePaymentIntegrationConfiguration _functionCommercePaymentIntegrationConfiguration;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private PortalCatapult _portalCatapult;

    public CommercePaymentEntry authorize(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        return this._setCommercePaymentEntry(httpServletRequest, commercePaymentEntry, "/authorize");
    }

    public CommercePaymentEntry cancel(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        return this._setCommercePaymentEntry(httpServletRequest, commercePaymentEntry, "/cancel");
    }

    public CommercePaymentEntry capture(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        return this._setCommercePaymentEntry(httpServletRequest, commercePaymentEntry, "/capture");
    }

    public String getDescription(Locale locale) {
        return this._functionCommercePaymentIntegrationConfiguration.name();
    }

    public String getKey() {
        return this._functionCommercePaymentIntegrationConfiguration.key();
    }

    public String getName(Locale locale) {
        return this._functionCommercePaymentIntegrationConfiguration.name();
    }

    public int getPaymentIntegrationType() {
        return this._functionCommercePaymentIntegrationConfiguration.paymentIntegrationType();
    }

    public UnicodeProperties getPaymentIntegrationTypeSettings() {
        return UnicodePropertiesBuilder.create((boolean)true).putAll((Map)ObjectMapperUtil.readValue(Map.class, (String)this._functionCommercePaymentIntegrationConfiguration.paymentIntegrationTypeSettings())).build();
    }

    public CommercePaymentEntry refund(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        return this._setCommercePaymentEntry(httpServletRequest, commercePaymentEntry, "/refund");
    }

    public CommercePaymentEntry setUpPayment(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws PortalException {
        return this._setCommercePaymentEntry(httpServletRequest, commercePaymentEntry, "/set-up-payment");
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._functionCommercePaymentIntegrationConfiguration = (FunctionCommercePaymentIntegrationConfiguration)ConfigurableUtil.createConfigurable(FunctionCommercePaymentIntegrationConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        String key = this.getKey();
        if (key == null) {
            return;
        }
        List commercePaymentMethodGroupRels = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(-1, -1);
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            if (!key.equals(commercePaymentMethodGroupRel.getPaymentIntegrationKey())) continue;
            this._commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws PortalException {
        this._functionCommercePaymentIntegrationConfiguration = (FunctionCommercePaymentIntegrationConfiguration)ConfigurableUtil.createConfigurable(FunctionCommercePaymentIntegrationConfiguration.class, properties);
        List commercePaymentMethodGroupRels = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(-1, -1);
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            String key = (String)properties.get("key");
            if (!key.equals(commercePaymentMethodGroupRel.getPaymentIntegrationKey())) continue;
            this._commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
        }
    }

    private JSONObject _getPayloadJSONObject(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commercePaymentEntry.getCommerceChannelId());
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commerceChannel.getGroupId(), this.getKey());
        UnicodeProperties typeSettingsUnicodeProperties = commercePaymentMethodGroupRel.getTypeSettingsUnicodeProperties();
        JSONObject typeSettingsJSONObject = this._jsonFactory.createJSONObject();
        typeSettingsUnicodeProperties.forEach((arg_0, arg_1) -> ((JSONObject)typeSettingsJSONObject).put(arg_0, arg_1));
        JSONObject commercePaymentEntryJSONObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep((Object)commercePaymentEntry));
        String className = this._portal.getClassName(commercePaymentEntry.getClassNameId());
        commercePaymentEntryJSONObject.put("className", className).put("classNameLabel", this._language.get(ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleUtil.fromLanguageId((String)commercePaymentEntry.getLanguageId()), this.getClass()), "model.resource." + className));
        return JSONUtil.put((String)"commercePaymentEntry", (Object)commercePaymentEntryJSONObject).put("httpServletRequestParameterMap", (Object)httpServletRequest.getParameterMap()).put("typeSettings", typeSettingsJSONObject);
    }

    private CommercePaymentEntry _setCommercePaymentEntry(HttpServletRequest httpServletRequest, CommercePaymentEntry commercePaymentEntry, String resourcePath) {
        try {
            commercePaymentEntry.setPaymentStatus(4);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(new String((byte[])this._portalCatapult.launch(commercePaymentEntry.getCompanyId(), Http.Method.POST, this._functionCommercePaymentIntegrationConfiguration.oAuth2ApplicationExternalReferenceCode(), this._getPayloadJSONObject(httpServletRequest, commercePaymentEntry), resourcePath, commercePaymentEntry.getUserId()).get()));
            if (jsonObject.has("amount")) {
                commercePaymentEntry.setAmount(BigDecimal.valueOf(jsonObject.getDouble("amount")));
            }
            if (jsonObject.has("callbackURL")) {
                commercePaymentEntry.setCallbackURL(jsonObject.getString("callbackURL"));
            }
            if (jsonObject.has("cancelURL")) {
                commercePaymentEntry.setCancelURL(jsonObject.getString("cancelURL"));
            }
            if (jsonObject.has("errorMessages")) {
                commercePaymentEntry.setErrorMessages(jsonObject.getString("errorMessages"));
            }
            if (jsonObject.has("note")) {
                commercePaymentEntry.setNote(jsonObject.getString("note"));
            }
            if (jsonObject.has("payload")) {
                commercePaymentEntry.setPayload(jsonObject.getString("payload"));
            }
            if (jsonObject.has("paymentStatus")) {
                commercePaymentEntry.setPaymentStatus(jsonObject.getInt("paymentStatus"));
            }
            if (jsonObject.has("redirectURL")) {
                commercePaymentEntry.setRedirectURL(jsonObject.getString("redirectURL"));
            }
            if (jsonObject.has("transactionCode")) {
                commercePaymentEntry.setTransactionCode(jsonObject.getString("transactionCode"));
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            commercePaymentEntry.setErrorMessages(exception.getMessage());
            commercePaymentEntry.setPaymentStatus(4);
        }
        return commercePaymentEntry;
    }
}

