/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileAppContent;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppContentCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppContentCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppContentCollectionResponse;
import com.microsoft.graph.requests.extensions.MobileAppContentRequestBuilder;
import java.util.List;

public class MobileAppContentCollectionRequest
extends BaseCollectionRequest<MobileAppContentCollectionResponse, IMobileAppContentCollectionPage>
implements IMobileAppContentCollectionRequest {
    public MobileAppContentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppContentCollectionResponse.class, IMobileAppContentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppContentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileAppContentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppContentCollectionPage get() throws ClientException {
        MobileAppContentCollectionResponse response = (MobileAppContentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileAppContent newMobileAppContent, ICallback<MobileAppContent> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppContent, callback);
    }

    @Override
    public MobileAppContent post(MobileAppContent newMobileAppContent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppContentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppContent);
    }

    @Override
    public IMobileAppContentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMobileAppContentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppContentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IMobileAppContentCollectionPage buildFromResponse(MobileAppContentCollectionResponse response) {
        MobileAppContentCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppContentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppContentCollectionPage page = new MobileAppContentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

