/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveSharedWithMeCollectionPage;
import com.microsoft.graph.requests.extensions.DriveSharedWithMeCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveSharedWithMeCollectionResponse;
import com.microsoft.graph.requests.extensions.IDriveSharedWithMeCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveSharedWithMeCollectionRequest;
import java.util.List;

public class DriveSharedWithMeCollectionRequest
extends BaseCollectionRequest<DriveSharedWithMeCollectionResponse, IDriveSharedWithMeCollectionPage>
implements IDriveSharedWithMeCollectionRequest {
    public DriveSharedWithMeCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveSharedWithMeCollectionResponse.class, IDriveSharedWithMeCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveSharedWithMeCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveSharedWithMeCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveSharedWithMeCollectionPage get() throws ClientException {
        DriveSharedWithMeCollectionResponse response = (DriveSharedWithMeCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveSharedWithMeCollectionPage buildFromResponse(DriveSharedWithMeCollectionResponse response) {
        DriveSharedWithMeCollectionRequestBuilder builder = response.nextLink != null ? new DriveSharedWithMeCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveSharedWithMeCollectionPage page = new DriveSharedWithMeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveSharedWithMeCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveSharedWithMeCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveSharedWithMeCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

