/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveItemGetActivitiesByIntervalCollectionPage;
import com.microsoft.graph.requests.extensions.DriveItemGetActivitiesByIntervalCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemGetActivitiesByIntervalCollectionResponse;
import com.microsoft.graph.requests.extensions.IDriveItemGetActivitiesByIntervalCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveItemGetActivitiesByIntervalCollectionRequest;
import java.util.List;

public class DriveItemGetActivitiesByIntervalCollectionRequest
extends BaseCollectionRequest<DriveItemGetActivitiesByIntervalCollectionResponse, IDriveItemGetActivitiesByIntervalCollectionPage>
implements IDriveItemGetActivitiesByIntervalCollectionRequest {
    public DriveItemGetActivitiesByIntervalCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItemGetActivitiesByIntervalCollectionResponse.class, IDriveItemGetActivitiesByIntervalCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemGetActivitiesByIntervalCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveItemGetActivitiesByIntervalCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemGetActivitiesByIntervalCollectionPage get() throws ClientException {
        DriveItemGetActivitiesByIntervalCollectionResponse response = (DriveItemGetActivitiesByIntervalCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveItemGetActivitiesByIntervalCollectionPage buildFromResponse(DriveItemGetActivitiesByIntervalCollectionResponse response) {
        DriveItemGetActivitiesByIntervalCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemGetActivitiesByIntervalCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemGetActivitiesByIntervalCollectionPage page = new DriveItemGetActivitiesByIntervalCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveItemGetActivitiesByIntervalCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemGetActivitiesByIntervalCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveItemGetActivitiesByIntervalCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

