/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.view.count.service.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.mass.delete.MassDeleteCacheThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.ReindexCacheThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.SQLStateAcceptor;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.view.count.configuration.ViewCountConfiguration;
import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.model.ViewCountEntryModel;
import com.liferay.view.count.model.ViewCountEntryTable;
import com.liferay.view.count.model.listener.ViewCountEntryModelListener;
import com.liferay.view.count.service.ViewCountEntryLocalService;
import com.liferay.view.count.service.base.ViewCountEntryLocalServiceBaseImpl;
import com.liferay.view.count.service.persistence.ViewCountEntryPK;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(configurationPid={"com.liferay.view.count.configuration.ViewCountConfiguration"}, property={"model.class.name=com.liferay.view.count.model.ViewCountEntry"}, service={AopService.class})
public class ViewCountEntryLocalServiceImpl
extends ViewCountEntryLocalServiceBaseImpl
implements ViewCountManager {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private volatile Set<String> _disabledClassNames;
    private volatile boolean _enabled;
    private ServiceTrackerMap<String, ViewCountEntryModelListener> _serviceTrackerMap;

    public void deleteViewCount(long companyId, long classNameId, long classPK) {
        Map partitionViewCountEntries = (Map)MassDeleteCacheThreadLocal.getMassDeleteCache((String)StringBundler.concat((Object[])new Object[]{ViewCountEntryLocalServiceImpl.class.getName(), ".deleteViewCount#", companyId, classNameId}), () -> MapUtil.toPartitionMap((List)this.viewCountEntryPersistence.findByC_CN(companyId, classNameId), ViewCountEntryModel::getClassPK));
        if (partitionViewCountEntries == null) {
            ViewCountEntryPK viewCountEntryPK = new ViewCountEntryPK(companyId, classNameId, classPK);
            ViewCountEntry viewCountEntry2 = this.viewCountEntryPersistence.fetchByPrimaryKey(viewCountEntryPK);
            if (viewCountEntry2 != null) {
                this.viewCountEntryPersistence.remove((BaseModel)viewCountEntry2);
            }
            return;
        }
        List viewCountEntries = (List)partitionViewCountEntries.remove(classPK);
        ListUtil.isNotEmptyForEach((List)viewCountEntries, viewCountEntry -> this.viewCountEntryPersistence.remove((BaseModel)viewCountEntry));
    }

    @Override
    public Class<?>[] getAopInterfaces() {
        return new Class[]{IdentifiableOSGiService.class, PersistedModelLocalService.class, ViewCountEntryLocalService.class, ViewCountManager.class};
    }

    public long getViewCount(long companyId, long classNameId, long classPK) {
        if (this.isViewCountEnabled(classNameId)) {
            return this._getViewCount(companyId, classNameId, classPK);
        }
        return 0L;
    }

    public Table<?> getViewCountEntryTable() {
        return ViewCountEntryTable.INSTANCE;
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23,40")})
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void incrementViewCount(long companyId, long classNameId, long classPK, int increment) {
        if (!this.isViewCountEnabled(classNameId)) {
            return;
        }
        this.viewCountEntryFinder.incrementViewCount(companyId, classNameId, classPK, increment);
        ClassName className = this._classNameLocalService.fetchClassName(classNameId);
        if (className == null) {
            return;
        }
        ViewCountEntryModelListener viewCountIncrementListener = (ViewCountEntryModelListener)this._serviceTrackerMap.getService((Object)className.getValue());
        if (viewCountIncrementListener == null) {
            return;
        }
        viewCountIncrementListener.onAfterIncrement(this.fetchViewCountEntry(new ViewCountEntryPK(companyId, classNameId, classPK)));
    }

    @Transactional(enabled=false)
    public boolean isViewCountEnabled() {
        return this._enabled;
    }

    @Transactional(enabled=false)
    public boolean isViewCountEnabled(long classNameId) {
        if (!this.isViewCountEnabled()) {
            return false;
        }
        ClassName className = this._classNameLocalService.fetchByClassNameId(classNameId);
        return !this._disabledClassNames.contains(className.getValue());
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ViewCountEntryModelListener.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.createFromFunction((BundleContext)bundleContext, ViewCountEntryModelListener::getModelClassName));
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        ViewCountConfiguration viewCountConfiguration = (ViewCountConfiguration)ConfigurableUtil.createConfigurable(ViewCountConfiguration.class, properties);
        HashSet<String> disabledClassNames = new HashSet<String>();
        for (String className : viewCountConfiguration.disabledClassNames()) {
            if (!Validator.isNotNull((String)className)) continue;
            disabledClassNames.add(className);
        }
        this._disabledClassNames = disabledClassNames;
        this._enabled = viewCountConfiguration.enabled();
    }

    private long _getViewCount(long companyId, long classNameId, long classPK) {
        Map indexedViewCounts = (Map)ReindexCacheThreadLocal.getScopeReindexCache((String)ViewCountEntryLocalServiceImpl.class.getName(), (String)String.valueOf(classNameId), () -> this.viewCountEntryPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)ViewCountEntryTable.INSTANCE).where(ViewCountEntryTable.INSTANCE.companyId.eq((Object)companyId)), false), () -> this.viewCountEntryPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)ViewCountEntryTable.INSTANCE).where(ViewCountEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)ViewCountEntryTable.INSTANCE.classNameId.eq((Object)classNameId))), false), count -> {
            HashMap<Long, Long> localIndexedViewCounts = new HashMap<Long, Long>();
            if (count == 0) {
                return localIndexedViewCounts;
            }
            GroupByStep dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{ViewCountEntryTable.INSTANCE.classPK, ViewCountEntryTable.INSTANCE.viewCount}).from((Table)ViewCountEntryTable.INSTANCE).where(ViewCountEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)ViewCountEntryTable.INSTANCE.classNameId.eq((Object)classNameId)));
            for (Object[] values : (List)this.viewCountEntryPersistence.dslQuery((DSLQuery)dslQuery, false)) {
                localIndexedViewCounts.put((Long)values[0], (Long)values[1]);
            }
            return localIndexedViewCounts;
        });
        if (indexedViewCounts == null) {
            ViewCountEntry viewCountEntry = this.viewCountEntryPersistence.fetchByPrimaryKey(new ViewCountEntryPK(companyId, classNameId, classPK));
            if (viewCountEntry == null) {
                return 0L;
            }
            return viewCountEntry.getViewCount();
        }
        Long viewCount = (Long)indexedViewCounts.get(classPK);
        if (viewCount == null) {
            return 0L;
        }
        return viewCount;
    }
}

