/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sync.model.impl;

import com.liferay.sync.model.SyncDevice;
import com.liferay.sync.service.SyncDeviceLocalServiceUtil;

/**
 * The extended model base implementation for the SyncDevice service. Represents a row in the &quot;SyncDevice&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SyncDeviceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SyncDeviceImpl
 * @see SyncDevice
 * @generated
 */
public abstract class SyncDeviceBaseImpl
	extends SyncDeviceModelImpl implements SyncDevice {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sync device model instance should use the <code>SyncDevice</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SyncDeviceLocalServiceUtil.addSyncDevice(this);
		}
		else {
			SyncDeviceLocalServiceUtil.updateSyncDevice(this);
		}
	}

}